/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.meexplorer.navigator;

import com.genuitec.eclipse.meexplorer.MEExplorerPlugin;
import java.io.File;
import java.util.TreeSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.internal.navigator.StringMatcher;

public class FilenameFilterJob
extends Job {
    private TreeSet<String> resultSet;
    private StringMatcher matcher;
    private boolean isFolderExcludeFilter = false;

    public FilenameFilterJob(String name) {
        super(name);
    }

    public void initialize(String filterText, boolean caseSensitiveEnableState, boolean isFolderExcludeFilter) {
        this.resultSet = new TreeSet();
        this.isFolderExcludeFilter = isFolderExcludeFilter;
        this.matcher = new StringMatcher(filterText, !caseSensitiveEnableState, false);
    }

    protected IStatus run(IProgressMonitor arg0) {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            if (project.exists() && project.isAccessible()) {
                boolean isValidResource = false;
                if (!this.isFolderExcludeFilter) {
                    isValidResource = this.validateResource((IResource)project);
                }
                if (!isValidResource) {
                    try {
                        IResource[] resources = project.members();
                        this.populateRequiredChildrenSet(resources);
                    }
                    catch (CoreException e) {
                        this.resultSet = null;
                        MEExplorerPlugin.getDefault().log("Failed while populating resultset for filename filtering", e, 4);
                    }
                }
            }
            ++i;
        }
        return Status.OK_STATUS;
    }

    protected void populateRequiredChildrenSet(IResource[] resources) throws CoreException {
        int i = 0;
        while (i < resources.length) {
            if (resources[i] instanceof IFile) {
                IResource file = resources[i];
                this.validateResource(file);
            } else if (resources[i] instanceof IFolder) {
                IResource folder = resources[i];
                boolean isValidResource = false;
                if (!this.isFolderExcludeFilter) {
                    isValidResource = this.validateResource(folder);
                }
                if (!isValidResource) {
                    this.populateRequiredChildrenSet(((IFolder)resources[i]).members());
                }
            }
            ++i;
        }
    }

    private boolean validateResource(IResource resource) {
        boolean isValidFile = this.validateFileName(resource.getName());
        if (isValidFile) {
            String resourcePath = String.valueOf(resource.getFullPath().toOSString()) + File.separatorChar;
            this.resultSet.add(resourcePath);
        }
        return isValidFile;
    }

    private boolean validateFileName(String fileNameWithExtension) {
        if (this.matcher != null) {
            return this.matcher.match(fileNameWithExtension);
        }
        return false;
    }

    public TreeSet<String> getResultSet() {
        return this.resultSet;
    }

    public boolean isFolderExcludeFilter() {
        return this.isFolderExcludeFilter;
    }
}

