/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.core.ui.wizard;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ScrolledFormText;

public class RichTextPage
extends WizardPage
implements IWizardPage {
    private String richText;
    private int textHeight = 200;
    private ScrolledFormText richTextControl;

    public RichTextPage(String thePageName, String theTitle, String description, ImageDescriptor theTitleImage, String text) {
        super(thePageName, theTitle, theTitleImage);
        this.setDescription(description);
        this.richText = text;
    }

    public void setTextHeight(int theTextHeight) {
        this.textHeight = theTextHeight;
    }

    public void createControl(Composite parent) {
        this.setPageComplete(true);
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 8;
        layout.marginWidth = 8;
        layout.verticalSpacing = 6;
        container.setLayout((Layout)layout);
        this.richTextControl = new ScrolledFormText(container, 2816, true);
        GridData gd = new GridData(4, 4, true, true);
        gd.heightHint = this.textHeight;
        this.richTextControl.getFormText().marginHeight = 2;
        this.richTextControl.getFormText().marginWidth = 4;
        this.richTextControl.setLayoutData((Object)gd);
        this.richTextControl.setBackground(new Color((Device)this.richTextControl.getDisplay(), 255, 255, 255));
        this.richTextControl.setText(this.richText);
        this.richTextControl.getFormText().addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent theE) {
                RichTextPage.this.openDoc((String)theE.getHref());
            }
        });
    }

    protected void openDoc(String url) {
        PlatformUI.getWorkbench().getHelpSystem().displayHelpResource(url);
    }

    public String getRichText() {
        return this.richText;
    }

    public void setRichText(String theText) {
        this.richText = theText;
        if (this.richTextControl != null && !this.richTextControl.isDisposed()) {
            this.richTextControl.setText(this.richText);
        }
    }
}

