/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.core.ui.wizard;

import com.genuitec.eclipse.core.Messages;
import com.genuitec.eclipse.core.portability.wizard.ComboDialogField;
import com.genuitec.eclipse.core.portability.wizard.DialogField;
import com.genuitec.eclipse.core.portability.wizard.IDialogFieldListener;
import com.genuitec.eclipse.core.portability.wizard.IListAdapter;
import com.genuitec.eclipse.core.portability.wizard.IStringButtonAdapter;
import com.genuitec.eclipse.core.portability.wizard.LayoutUtil;
import com.genuitec.eclipse.core.portability.wizard.ListDialogField;
import com.genuitec.eclipse.core.portability.wizard.SelectionButtonDialogField;
import com.genuitec.eclipse.core.portability.wizard.Separator;
import com.genuitec.eclipse.core.portability.wizard.StringButtonDialogField;
import com.genuitec.eclipse.core.portability.wizard.StringDialogField;
import com.genuitec.eclipse.core.util.UIUtil;
import com.genuitec.eclipse.core.util.Util;
import java.util.LinkedList;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class DialogFieldUtil {
    public static String BUTTON_ADD = Messages.DialogFieldUtil_button_add_label;
    public static String BUTTON_BROWSE = Messages.DialogFieldUtil_button_browse_label;
    public static String BUTTON_DOWN = Messages.DialogFieldUtil_button_down_label;
    public static String BUTTON_EDIT = Messages.DialogFieldUtil_button_edit_label;
    public static String BUTTON_REMOVE = Messages.DialogFieldUtil_button_remove_label;
    public static String BUTTON_UP = Messages.DialogFieldUtil_button_up_label;
    public static String[] BUTTONS_LIST_ALL = new String[]{BUTTON_ADD, BUTTON_EDIT, BUTTON_REMOVE, BUTTON_UP, BUTTON_DOWN};
    public static String[] BUTTONS_LIST_EDITING = new String[]{BUTTON_ADD, BUTTON_EDIT, BUTTON_REMOVE};

    public static ComboDialogField createCombo(Composite composite, IDialogFieldListener listener, String label, String[] items, int defaultIndex, boolean readOnly) {
        int style = 4 | (readOnly ? 8 : 0);
        ComboDialogField combo = new ComboDialogField(style);
        combo.setLabelText(label);
        combo.setItems(items);
        if (defaultIndex >= 0 && defaultIndex < items.length) {
            combo.selectItem(defaultIndex);
        }
        combo.doFillIntoGrid(composite, 2);
        combo.setDialogFieldListener(listener);
        return combo;
    }

    public static SelectionButtonDialogField createCheckbox(Composite composite, IDialogFieldListener listener, String label) {
        SelectionButtonDialogField checkBox = new SelectionButtonDialogField(32);
        checkBox.setLabelText(label);
        checkBox.doFillIntoGrid(composite, 2);
        checkBox.setDialogFieldListener(listener);
        return checkBox;
    }

    public static ListDialogField createListControl(Composite attributesTabContents, IListAdapter adapter, ILabelProvider provider, String labelText, String[] columns) {
        ListDialogField dialogField = new ListDialogField(adapter, BUTTONS_LIST_EDITING, provider);
        if (labelText != null) {
            dialogField.setLabelText(labelText);
        }
        dialogField.setTableColumns(new ListDialogField.ColumnsDescription(columns, true));
        dialogField.doFillIntoGrid(attributesTabContents, 3);
        Control listControl = dialogField.getListControl(attributesTabContents);
        LayoutUtil.setHorizontalGrabbing((Control)listControl);
        UIUtil.setVerticalGrabbing((Control)listControl);
        dialogField.setRemoveButtonIndex(2);
        dialogField.setElements(new LinkedList());
        dialogField.enableButton(1, false);
        return dialogField;
    }

    public static StringDialogField createTextField(Composite composite, IDialogFieldListener listener, String label, String initValue) {
        StringDialogField field = new StringDialogField();
        field.setTextWithoutUpdate(Util.emptyIfNull((String)initValue));
        field.setLabelText(label);
        field.doFillIntoGrid(composite, 2);
        field.setDialogFieldListener(listener);
        LayoutUtil.setHorizontalGrabbing((Control)field.getTextControl(composite));
        DialogField.createEmptySpace((Composite)composite);
        return field;
    }

    public static StringButtonDialogField createTextFieldWithBrowseButton(Composite composite, String label, IStringButtonAdapter adapter, IDialogFieldListener listener, int widthHint, String initValue) {
        StringButtonDialogField dialogField = new StringButtonDialogField(adapter);
        dialogField.setLabelText(label);
        dialogField.setTextWithoutUpdate(Util.emptyIfNull((String)initValue));
        dialogField.setButtonLabel(BUTTON_BROWSE);
        dialogField.doFillIntoGrid(composite, 3);
        LayoutUtil.setHorizontalGrabbing((Control)dialogField.getTextControl(composite));
        if (widthHint > 0) {
            LayoutUtil.setWidthHint((Control)dialogField.getTextControl(composite), (int)widthHint);
        }
        dialogField.setDialogFieldListener(listener);
        return dialogField;
    }

    public static Separator createSeparator(Composite composite, int nColumns, int height) {
        Separator sep = new Separator(258);
        sep.doFillIntoGrid(composite, nColumns, height);
        return sep;
    }

    public static void makeReadOnly(StringDialogField stringDF, boolean value) {
        Text text = stringDF.getTextControl(null);
        if (text != null) {
            text.setEditable(!value);
        }
    }

    public static void makeReadOnly(StringButtonDialogField stringButtonDF, boolean value) {
        Text text = stringButtonDF.getTextControl(null);
        if (text != null) {
            text.setEditable(!value);
        }
    }
}

