/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.core.ui.preference;

import com.genuitec.eclipse.core.JavaVMUIUtility;
import com.genuitec.eclipse.core.Messages;
import com.genuitec.eclipse.core.ui.wizard.AddStandardVMInstallWizard;
import com.genuitec.eclipse.core.util.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.internal.debug.ui.jres.JREsUpdater;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall2;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMStandin;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Widget;

public class JDKFieldEditor
extends FieldEditor {
    private static final int RUN_MODE = 0;
    private static final int INIT_MODE = 1;
    private static final int VM_ADDING_MODE = 2;
    private int mode = 0;
    protected IVMInstallType[] vmTypes;
    protected List vmInfos;
    protected String defaultVMName;
    private Button button;
    private Combo fCombo;
    private String fValue;
    protected String jdkName;
    private final boolean jdkOnly;

    public boolean isDuplicateName(String name) {
        return this.getVMInfoNamed(name) != null;
    }

    public void vmAdded(IVMInstall theVMInstall) {
        if (this.mode == 1) {
            return;
        }
        IVMInstall vmInstall = theVMInstall;
        if (vmInstall instanceof VMStandin) {
            vmInstall = ((VMStandin)vmInstall).convertToRealVM();
            JREsUpdater updater = new JREsUpdater();
            IVMInstall def = JavaRuntime.getDefaultVMInstall();
            LinkedList<IVMInstall> fOriginalVMs = new LinkedList<IVMInstall>();
            IVMInstallType[] types = JavaRuntime.getVMInstallTypes();
            int i = 0;
            while (i < types.length) {
                IVMInstall[] vms = types[i].getVMInstalls();
                int j = 0;
                while (j < vms.length) {
                    fOriginalVMs.add(vms[j]);
                    ++j;
                }
                ++i;
            }
            updater.updateJRESettings(fOriginalVMs.toArray(new IVMInstall[fOriginalVMs.size()]), def);
        }
        if (vmInstall.getName() == null) {
            return;
        }
        VMInfo vmInfo = this.getVMInfoNamed(vmInstall.getName());
        if (vmInfo != null) {
            return;
        }
        this.addVM(vmInstall);
        this.initializeJREComboBox(vmInstall.getName());
        if (this.mode == 2) {
            this.selectJREComboBoxEntry(vmInstall.getName());
        }
    }

    public void vmRemoved(IVMInstall theVMInstall) {
        VMInfo vmInfo = this.getVMInfoNamed(theVMInstall.getName());
        if (vmInfo == null) {
            return;
        }
        this.vmInfos.remove(vmInfo);
        this.populateJREComboBox();
        this.selectJREComboBoxEntry(vmInfo.getName());
    }

    public JDKFieldEditor(String name, String labelText, Composite parent, boolean jdkOnly) {
        this.jdkOnly = jdkOnly;
        this.init(name, labelText);
        this.createControl(parent);
    }

    protected void adjustForNumColumns(int numColumns) {
        int numColumns1 = numColumns - 1;
        if (numColumns1 > 1) {
            Label control = this.getLabelControl();
            int left = numColumns1;
            if (control != null) {
                ((GridData)control.getLayoutData()).horizontalSpan = 1;
                --left;
            }
            ((GridData)this.fCombo.getLayoutData()).horizontalSpan = left;
        } else {
            Label control = this.getLabelControl();
            if (control != null) {
                ((GridData)control.getLayoutData()).horizontalSpan = 1;
            }
            ((GridData)this.fCombo.getLayoutData()).horizontalSpan = 1;
        }
    }

    protected String constructDefaultJREName(String theName) {
        return theName != null ? theName.trim() : "";
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        int numColumns1 = numColumns - 1;
        int comboC = 1;
        if (numColumns1 > 1) {
            comboC = numColumns1 - 1;
        }
        Label control = this.getLabelControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = 1;
        control.setLayoutData((Object)gd);
        control = this.getComboBoxControl(parent);
        gd = new GridData();
        gd.horizontalSpan = comboC;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        control.setLayoutData((Object)gd);
        control.setFont(parent.getFont());
        control = this.getAddButton(parent);
    }

    protected void doLoad() {
        this.updateComboForValue(this.getPreferenceStore().getString(this.getPreferenceName()));
    }

    protected void doLoadDefault() {
        this.updateComboForValue(this.getPreferenceStore().getDefaultString(this.getPreferenceName()));
    }

    protected void doStore() {
        if (this.fValue == null) {
            this.getPreferenceStore().setToDefault(this.getPreferenceName());
            return;
        }
        this.getPreferenceStore().setValue(this.getPreferenceName(), this.fValue);
    }

    protected Button getAddButton(Composite parent) {
        if (this.button == null) {
            this.button = new Button(parent, 0);
            this.button.setFont(parent.getFont());
            this.button.setText(Messages.JDKFieldEditor_button_add_label);
            this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    JDKFieldEditor.this.handleJREAddButtonSelected(e.widget);
                }
            });
        }
        return this.button;
    }

    private Combo getComboBoxControl(Composite parent) {
        if (this.fCombo == null) {
            this.fCombo = new Combo(parent, 8);
            this.fCombo.setFont(parent.getFont());
            this.fCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    String oldValue = JDKFieldEditor.this.fValue;
                    String name = JDKFieldEditor.this.fCombo.getText();
                    JDKFieldEditor.this.fValue = JDKFieldEditor.this.getValueForName(name);
                    JDKFieldEditor.this.setPresentsDefaultValue(false);
                    JDKFieldEditor.this.fireValueChanged("field_editor_value", oldValue, JDKFieldEditor.this.fValue);
                }
            });
            this.fillJDKs(this.fCombo);
        }
        return this.fCombo;
    }

    private void fillJDKs(Combo combo) {
        List infos = this.getVMInfos();
        String[] names = new String[infos.size()];
        int ind = 0;
        for (VMInfo info : infos) {
            names[ind++] = info.getName();
        }
        combo.setItems(names);
    }

    public int getNumberOfControls() {
        return 3;
    }

    private String getValueForName(String name) {
        VMInfo infoNamed = this.getVMInfoNamed(name);
        if (infoNamed != null) {
            return infoNamed.getPath().toString();
        }
        return "";
    }

    protected String getCurrentVMVersion() {
        VMInfo infoNamed = this.getVMInfoNamed(this.fCombo.getText());
        return infoNamed != null ? infoNamed.getVersion() : null;
    }

    protected boolean isCurrentVMJDK() {
        VMInfo infoNamed = this.getVMInfoNamed(this.fCombo.getText());
        return infoNamed != null ? JavaVMUIUtility.isJDK((IVMInstall)infoNamed.getVMInstall()) : false;
    }

    protected VMInfo getVMInfoNamed(String theName) {
        VMInfo result = null;
        for (VMInfo info : this.getVMInfos()) {
            if (!info.getName().equals(theName)) continue;
            result = info;
            break;
        }
        return result;
    }

    protected List getVMInfos() {
        if (this.vmInfos == null) {
            this.initVMInfo();
        }
        return this.vmInfos;
    }

    protected int getVMNameIndex(String searchVMName) {
        String[] vmNames = this.fCombo.getItems();
        int i = 0;
        while (i < vmNames.length) {
            if (vmNames[i].equals(searchVMName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected void handleJREAddButtonSelected(Widget theWidget) {
        this.mode = 2;
        try {
            IVMInstall[] installs = JavaRuntime.getVMInstallType((String)"org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType").getVMInstalls();
            AddStandardVMInstallWizard wizard = new AddStandardVMInstallWizard(installs);
            wizard.setWindowTitle(Messages.JDKFieldEditor_title_add_jvm_dialog);
            WizardDialog dialog = new WizardDialog(this.getPage().getShell(), (IWizard)wizard);
            if (dialog.open() != 0) {
                return;
            }
            this.vmAdded((IVMInstall)wizard.getResult());
        }
        finally {
            this.mode = 0;
        }
    }

    protected void initializeJREComboBox(String vmInstallId) {
        this.mode = 1;
        try {
            this.initVMInfo();
            this.populateJREComboBox();
            this.selectJREComboBoxEntry(vmInstallId);
        }
        finally {
            this.mode = 0;
        }
    }

    private void initVMInfo() {
        this.vmTypes = JavaRuntime.getVMInstallTypes();
        IVMInstall defaultVM = JavaRuntime.getDefaultVMInstall();
        this.defaultVMName = defaultVM != null ? defaultVM.getName() : null;
        this.vmInfos = new ArrayList();
        if (defaultVM != null && defaultVM.getName() != null) {
            this.addVM(defaultVM);
        }
        int i = 0;
        while (i < this.vmTypes.length) {
            IVMInstall[] vmInstalls = this.vmTypes[i].getVMInstalls();
            int j = 0;
            while (j < vmInstalls.length) {
                if (this.defaultVMName == null || !this.defaultVMName.equals(vmInstalls[j].getName())) {
                    this.addVM(vmInstalls[j]);
                }
                ++j;
            }
            ++i;
        }
    }

    private void addVM(IVMInstall vm) {
        if (!this.jdkOnly || JavaVMUIUtility.isJDK((IVMInstall)vm)) {
            this.vmInfos.add(new VMInfo(vm));
        }
    }

    protected void populateJREComboBox() {
        ArrayList<String> vmNames = new ArrayList<String>();
        for (VMInfo standin : this.getVMInfos()) {
            String vmName = standin.getName();
            vmNames.add(vmName);
        }
        Collections.sort(vmNames);
        this.fCombo.setItems(vmNames.toArray(new String[vmNames.size()]));
    }

    protected void selectJREComboBoxEntry(String theJDKName) {
        String searchName = theJDKName;
        if (searchName == null || searchName.trim().length() == 0) {
            searchName = this.defaultVMName;
        }
        int index = this.getVMNameIndex(searchName);
        this.fCombo.select(index);
        String oldValue = this.fValue;
        this.fValue = this.getValueForName(theJDKName);
        this.setPresentsDefaultValue(false);
        this.fireValueChanged("field_editor_value", oldValue, this.fValue);
    }

    private void updateComboForValue(String value) {
        this.fValue = value;
        if (!Util.isNullOrEmpty((String)value)) {
            List infos = this.getVMInfos();
            int ind = 0;
            for (VMInfo info : infos) {
                if (info.getPath().equals((Object)new Path(value))) {
                    this.fCombo.select(ind);
                    break;
                }
                ++ind;
            }
        }
    }

    protected void updateJDKNameFromSelection() {
        int index = this.fCombo.getSelectionIndex();
        String string = this.jdkName = index >= 0 ? this.fCombo.getItem(index) : null;
        if (this.jdkName != null && !JavaVMUIUtility.vmIsFullJDK(this.jdkName)) {
            this.getPage().setErrorMessage(Messages.JDKFieldEditor_error_specify_full_jdk);
        } else {
            this.getPage().setErrorMessage(null);
        }
    }

    public static class VMInfo {
        private String id;
        private String name;
        private String type;
        private IPath path;
        private String version;
        private IVMInstall vmInstall;

        public VMInfo(IVMInstall theVMInstall) {
            this.id = theVMInstall.getId();
            this.name = theVMInstall.getName();
            this.type = theVMInstall.getVMInstallType().getName();
            this.path = JavaVMUIUtility.encode((IVMInstall)theVMInstall);
            this.vmInstall = theVMInstall;
            if (theVMInstall instanceof IVMInstall2) {
                this.version = ((IVMInstall2)theVMInstall).getJavaVersion();
            }
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public IPath getPath() {
            return this.path;
        }

        public String getVersion() {
            return this.version;
        }

        public IVMInstall getVMInstall() {
            return this.vmInstall;
        }
    }
}

