/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.core.ui.dialog;

import com.genuitec.eclipse.core.CommonUI;
import com.genuitec.eclipse.core.LicenseUtil;
import com.genuitec.eclipse.core.Messages;
import com.genuitec.eclipse.core.util.PlatformUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.TreeMap;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.internal.ProductProperties;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.update.configurator.ConfiguratorUtils;
import org.eclipse.update.configurator.IPlatformConfiguration;

public class ConfigurationSummaryDialog
extends Dialog {
    private static final int BROWSE_ERROR_LOG_BUTTON = 1024;
    private static final int COPY_TO_CLIPBOARD_BUTTON = 1025;
    private static final String ERROR_LOG_COPY_FILENAME = "log";
    private static final HashSet<String> primaryFeatures = new HashSet();
    private static final List<String> filterFeatures = new ArrayList<String>();
    private Text text;
    private Properties properties;

    static {
        primaryFeatures.add("com.genuitec.myeclipse.enterprise.workbench");
        primaryFeatures.add("com.genuitec.myeclipse.blue.feature");
        primaryFeatures.add("com.genuitec.myeclipse.pulse");
        primaryFeatures.add("com.genuitec.myeclipse.database");
        primaryFeatures.add("com.genuitec.myeclipse.db2");
        primaryFeatures.add("com.genuitec.myeclipse.desktop");
        primaryFeatures.add("com.genuitec.myeclipse.editor");
        primaryFeatures.add("com.genuitec.myeclipse.geronimo");
        primaryFeatures.add("com.genuitec.myeclipse.glassfish");
        primaryFeatures.add("com.genuitec.myeclipse.icefaces.feature");
        primaryFeatures.add("com.genuitec.myeclipse.iedebugger");
        primaryFeatures.add("com.genuitec.myeclipse.imageeditor");
        primaryFeatures.add("com.genuitec.myeclipse.jboss");
        primaryFeatures.add("com.genuitec.myeclipse.jetty");
        primaryFeatures.add("com.genuitec.myeclipse.jonas");
        primaryFeatures.add("com.genuitec.myeclipse.jrun");
        primaryFeatures.add("com.genuitec.myeclipse.jsf");
        primaryFeatures.add("com.genuitec.myeclipse.matisse");
        primaryFeatures.add("com.genuitec.myeclipse.maven");
        primaryFeatures.add("com.genuitec.myeclipse.oracle");
        primaryFeatures.add("com.genuitec.myeclipse.orion");
        primaryFeatures.add("com.genuitec.myeclipse.persistence");
        primaryFeatures.add("com.genuitec.myeclipse.reports");
        primaryFeatures.add("com.genuitec.myeclipse.resin");
        primaryFeatures.add("com.genuitec.myeclipse.spring.ajdt");
        primaryFeatures.add("com.genuitec.myeclipse.spring.mylyn");
        primaryFeatures.add("com.genuitec.myeclipse.struts");
        primaryFeatures.add("com.genuitec.myeclipse.sun");
        primaryFeatures.add("com.genuitec.myeclipse.tapestry");
        primaryFeatures.add("com.genuitec.myeclipse.tomcat");
        primaryFeatures.add("com.genuitec.myeclipse.uml2");
        primaryFeatures.add("com.genuitec.myeclipse.visualvm");
        primaryFeatures.add("com.genuitec.myeclipse.visualvm.server");
        primaryFeatures.add("com.genuitec.myeclipse.weblogic");
        primaryFeatures.add("com.genuitec.myeclipse.websphere");
        primaryFeatures.add("com.genuitec.myeclipse.ws");
        primaryFeatures.add("com.genuitec.myeclipse.ws.blue");
        primaryFeatures.add("com.genuitec.myeclipse.xfire");
        primaryFeatures.add("com.skyway.myeclipseforspring.feature");
        primaryFeatures.add("org.zeroturnaround.myeclipse.feature");
        primaryFeatures.add("org.eclipse.emf");
        primaryFeatures.add("org.eclipse.gef");
        primaryFeatures.add("org.eclipse.xsd");
        primaryFeatures.add("org.eclipse.jst.common.fproj.enablement.jdt");
        primaryFeatures.add("org.eclipse.jst.enterprise_ui.feature");
        primaryFeatures.add("org.eclipse.jst.server_adapters.ext.feature");
        primaryFeatures.add("org.eclipse.jst.server_adapters.feature");
        primaryFeatures.add("org.eclipse.jst.server_ui.feature");
        primaryFeatures.add("org.eclipse.jst.ws.axis2tools.feature");
        primaryFeatures.add("org.eclipse.wst.common.fproj");
        primaryFeatures.add("org.eclipse.wst.server_adapters.feature");
        primaryFeatures.add("org.eclipse.datatools.connectivity.feature");
        primaryFeatures.add("org.eclipse.datatools.enablement.feature");
        primaryFeatures.add("org.eclipse.datatools.modelbase.feature");
        primaryFeatures.add("org.eclipse.datatools.sqldevtools.feature");
        primaryFeatures.add("org.eclipse.jpt.jpa.feature");
        primaryFeatures.add("org.eclipse.jpt.jpadiagrameditor.feature");
        primaryFeatures.add("org.eclipse.m2e.feature");
        primaryFeatures.add("org.eclipse.sapphire.platform");
        primaryFeatures.add("org.springframework.ide.eclipse.feature");
        primaryFeatures.add("org.eclipse.birt");
        primaryFeatures.add("org.eclipse.graphiti.feature");
        primaryFeatures.add("com.genuitec.eclipse.mobile.feature");
        filterFeatures.add("com.genuitec");
        filterFeatures.add("com.skyway");
        filterFeatures.add("org.eclipse.wst");
        filterFeatures.add("org.eclipse.jst");
        filterFeatures.add("org.eclipse.emf");
        filterFeatures.add("org.eclipse.xsd");
        filterFeatures.add("org.eclipse.gef");
        filterFeatures.add("org.eclipse.datatools");
        filterFeatures.add("org.eclipse.jpt");
        filterFeatures.add("org.eclipse.m2e");
        filterFeatures.add("org.eclipse.sapphire");
        filterFeatures.add("org.springframework");
        filterFeatures.add("org.eclipse.birt");
        filterFeatures.add("org.eclipse.graphiti");
    }

    public ConfigurationSummaryDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(66576);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.ConfigurationSummaryDialog_title);
        shell.setSize(640, 477);
    }

    protected Control createDialogArea(Composite parent) {
        Composite outer = (Composite)super.createDialogArea(parent);
        this.text = new Text(outer, 527114);
        this.text.setBackground(parent.getDisplay().getSystemColor(25));
        GridData gridData = new GridData(272);
        gridData.grabExcessVerticalSpace = true;
        gridData.grabExcessHorizontalSpace = true;
        gridData.heightHint = this.convertVerticalDLUsToPixels(300);
        gridData.widthHint = this.convertHorizontalDLUsToPixels(400);
        this.text.setLayoutData((Object)gridData);
        this.text.setText(this.getConfigurationSummary());
        this.text.setFont(JFaceResources.getTextFont());
        return outer;
    }

    private String getConfigurationSummary() {
        StringBuffer output = new StringBuffer();
        this.properties = System.getProperties();
        this.appendLine(output, Messages.ConfigurationSummaryDialog_text_date);
        output.append(DateFormat.getDateTimeInstance(0, 0).format(new Date()));
        output.append(Messages.ConfigurationSummaryDialog_text_separator);
        this.appendLine(output, Messages.ConfigurationSummaryDialog_text_systemProperties);
        this.appendLine(output, "org.osgi.framework.os.name", Messages.ConfigurationSummaryDialog_text_operatingSystem);
        this.appendLine(output, "org.osgi.framework.os.version", Messages.ConfigurationSummaryDialog_text_operatingSystemVersion);
        this.appendLine(output, "os.arch", Messages.ConfigurationSummaryDialog_text_os_arch);
        this.appendLine(output, "osgi.arch", Messages.ConfigurationSummaryDialog_text_profile_arch);
        this.appendLine(output, "osgi.ws", Messages.ConfigurationSummaryDialog_text_ws);
        this.appendLine(output, "java.version", Messages.ConfigurationSummaryDialog_text_javaVersion);
        this.appendLine(output, "osgi.instance.area", Messages.ConfigurationSummaryDialog_text_workspace);
        this.appendLine(output, "eclipse.vmargs", Messages.ConfigurationSummaryDialog_text_vm_args);
        output.append(Messages.ConfigurationSummaryDialog_text_separator);
        try {
            String subInfo = LicenseUtil.getCurrentLicenseDetail().trim();
            output.append(Messages.ConfigurationSummaryDialog_text_sub_info);
            output.append(subInfo);
            output.append(Messages.ConfigurationSummaryDialog_text_separator);
        }
        catch (Exception e) {
            CommonUI.getDefault().log("Could not fetch license info", e);
        }
        this.appendLine(output, Messages.ConfigurationSummaryDialog_text_eclipseDetails);
        IProduct product = Platform.getProduct();
        if (product != null) {
            this.appendLine(output, ProductProperties.getAboutText((IProduct)product));
        }
        output.append(Messages.ConfigurationSummaryDialog_text_separator);
        TreeMap<String, IPlatformConfiguration.IFeatureEntry> knownMap = new TreeMap<String, IPlatformConfiguration.IFeatureEntry>();
        TreeMap<String, IPlatformConfiguration.IFeatureEntry> unKnownMap = new TreeMap<String, IPlatformConfiguration.IFeatureEntry>();
        IPlatformConfiguration platformConf = ConfiguratorUtils.getCurrentPlatformConfiguration();
        IPlatformConfiguration.IFeatureEntry[] features = platformConf.getConfiguredFeatureEntries();
        int i = 0;
        while (i < features.length) {
            IPlatformConfiguration.IFeatureEntry entry = features[i];
            String fId = entry.getFeatureIdentifier();
            int level = this.getFeatureLevel(fId);
            if (level == 1) {
                knownMap.put(fId, entry);
            } else if (level == 2) {
                unKnownMap.put(fId, entry);
            }
            ++i;
        }
        this.printFeatureDetails(output, knownMap);
        output.append(Messages.ConfigurationSummaryDialog_text_separator);
        this.printFeatureDetails(output, unKnownMap);
        output.append(Messages.ConfigurationSummaryDialog_text_separator);
        this.appendLine(output, "eclipse.commands", Messages.ConfigurationSummaryDialog_text_eclipseStartupCommand);
        return output.toString();
    }

    private void printFeatureDetails(StringBuffer output, TreeMap<String, IPlatformConfiguration.IFeatureEntry> map) {
        for (IPlatformConfiguration.IFeatureEntry entry : map.values()) {
            output.append(MessageFormat.format("{0} - {1}\n", entry.getFeatureIdentifier(), entry.getFeatureVersion()));
        }
    }

    private void appendLine(StringBuffer buffer, String property, String name) {
        buffer.append(MessageFormat.format(Messages.ConfigurationSummaryDialog_text_key_value, name, this.properties.get(property)));
    }

    private void appendLine(StringBuffer buffer, String infoText) {
        if (infoText != null) {
            buffer.append(MessageFormat.format(Messages.ConfigurationSummaryDialog_text_newline, infoText.split(Messages.ConfigurationSummaryDialog_text_copyrightSymbol)[0]));
        }
    }

    private int getFeatureLevel(String fId) {
        if (primaryFeatures.contains(fId)) {
            return 1;
        }
        for (String filterFeature : filterFeatures) {
            if (!fId.startsWith(filterFeature)) continue;
            return 0;
        }
        return 2;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        parent.setLayoutData((Object)new GridData(768));
        Button button = this.createButton(parent, 1024, WorkbenchMessages.AboutSystemDialog_browseErrorLogName, false);
        String filename = Platform.getLogFileLocation().toOSString();
        button.setEnabled(new File(filename).exists());
        this.createButton(parent, 1025, WorkbenchMessages.AboutSystemDialog_copyToClipboardName, false);
        new Label(parent, 0).setLayoutData((Object)new GridData(768));
        GridLayout layout = (GridLayout)parent.getLayout();
        ++layout.numColumns;
        layout.makeColumnsEqualWidth = false;
        this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, true);
    }

    protected void openLink(String href) {
        if (href.startsWith("file:")) {
            href = href.substring(5);
            while (href.startsWith("/")) {
                href = href.substring(1);
            }
            href = "file:///" + href;
        }
        IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
        try {
            IWebBrowser browser = support.getExternalBrowser();
            browser.openURL(new URL(PlatformUtil.urlEncodeForSpaces((char[])href.toCharArray())));
        }
        catch (MalformedURLException e) {
            this.openWebBrowserError(href, e);
        }
        catch (PartInitException e) {
            this.openWebBrowserError(href, e);
        }
    }

    private void openWebBrowserError(final String href, final Throwable t) {
        this.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                String title = "";
                String msg = NLS.bind((String)"", (Object)href);
                IStatus status = WorkbenchPlugin.getStatus((Throwable)t);
                ErrorDialog.openError((Shell)ConfigurationSummaryDialog.this.getShell(), (String)title, (String)msg, (IStatus)status);
            }
        });
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 12: {
                this.close();
                break;
            }
            case 1024: {
                this.openErrorLogBrowser();
                break;
            }
            case 1025: {
                this.runCopyToClipboard();
            }
        }
        super.buttonPressed(buttonId);
    }

    private void openErrorLogBrowser() {
        String filename = Platform.getLogFileLocation().toOSString();
        File log = new File(filename);
        if (log.exists()) {
            File logCopy = this.makeDisplayCopy(log);
            if (logCopy != null) {
                this.openLink("file:///" + logCopy.getAbsolutePath());
                return;
            }
            this.openLink("file:///" + filename);
            return;
        }
        MessageDialog.openInformation((Shell)this.getShell(), (String)"", (String)NLS.bind((String)"", (Object)filename));
    }

    private File makeDisplayCopy(File file) {
        IPath path = WorkbenchPlugin.getDefault().getDataLocation();
        if (path == null) {
            return null;
        }
        path = path.append(ERROR_LOG_COPY_FILENAME);
        File copy = path.toFile();
        FileReader in = null;
        OutputStreamWriter out = null;
        try {
            int count;
            in = new FileReader(file);
            out = new FileWriter(copy);
            char[] buffer = new char[4096];
            while ((count = in.read(buffer, 0, buffer.length)) > 0) {
                out.write(buffer, 0, count);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException iOException) {
                return null;
            }
            return null;
        }
        catch (IOException iOException) {
            try {}
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        in.close();
                    }
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException iOException2) {
                    return null;
                }
                throw throwable;
            }
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException iOException3) {
                return null;
            }
            return null;
        }
        try {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
        catch (IOException iOException) {
            return null;
        }
        return copy;
    }

    private void runCopyToClipboard() {
        if (this.text == null) {
            return;
        }
        Clipboard clipboard = null;
        try {
            clipboard = new Clipboard(this.getShell().getDisplay());
            clipboard.setContents(new Object[]{this.text.getText()}, new Transfer[]{TextTransfer.getInstance()});
        }
        finally {
            if (clipboard != null) {
                clipboard.dispose();
            }
        }
    }
}

