/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.core.portability;

import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.Assert;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.editors.text.ILocationProvider;

public class TempFileEditorInput
implements IEditorInput,
ILocationProvider {
    private static int fgNonExisting = 0;
    private IFileStore fFileStore;
    private String fName;

    public TempFileEditorInput(IFileStore fileStore, String namePrefix) {
        Assert.isNotNull((Object)fileStore);
        Assert.isTrue((boolean)"file".equals(fileStore.getFileSystem().getScheme()));
        this.fFileStore = fileStore;
        this.fName = String.valueOf(namePrefix) + " " + ++fgNonExisting;
    }

    public boolean exists() {
        return false;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        return this.fName;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return this.fName;
    }

    public Object getAdapter(Class adapter) {
        if (ILocationProvider.class.equals((Object)adapter)) {
            return this;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public IPath getPath(Object element) {
        if (element instanceof TempFileEditorInput) {
            TempFileEditorInput input = (TempFileEditorInput)element;
            return new Path(input.fFileStore.toURI().getPath());
        }
        return null;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TempFileEditorInput) {
            TempFileEditorInput input = (TempFileEditorInput)o;
            return this.fFileStore.equals(input.fFileStore);
        }
        return false;
    }

    public int hashCode() {
        return this.fFileStore.hashCode();
    }
}

