/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.core.activation;

import com.genuitec.eclipse.core.activation.InvalidSystemDataException;
import com.genuitec.eclipse.core.util.PlatformUtil;
import java.util.Random;

public final class SystemId {
    public static final int NODE_LOCKED = 1;
    public static final int NODE_UNLOCKED = 2;
    public static final String NO_HOST = "00";
    public static final String NO_SYSINFO = "0000000";
    public static final String NO_MAC = "0000";
    public static final String NO_HD = "0000";
    public static final int FORMAT_TYPE_FIELD_LENGTH = 1;
    public static final int FORMAT_FIELD_LENGTH = 1;
    public static final int HOST_FIELD_LENGTH = "00".length();
    public static final int SYSINFO_FIELD_LENGTH = "0000000".length();
    public static final int MAC_FIELD_LENGTH = "0000".length();
    public static final int HD_FIELD_LENGTH = "0000".length();
    public static final int SYSTEM_ID_LENGTH = 2 + HOST_FIELD_LENGTH + SYSINFO_FIELD_LENGTH + MAC_FIELD_LENGTH + HD_FIELD_LENGTH;
    private int D;
    private String C;
    private String B;
    private String E;
    private String A;

    public static SystemId fromCode(String string) throws InvalidSystemDataException {
        String string2 = NO_HOST;
        String string3 = NO_SYSINFO;
        String string4 = "0000";
        String string5 = "0000";
        if (PlatformUtil.isNullOrEmpty((String)string) || string.length() < SYSTEM_ID_LENGTH) {
            throw new InvalidLicenseDataException();
        }
        int n = Integer.parseInt(string.substring(0, 1), 16);
        if (n != 1 && n != 2) {
            throw new InvalidLicenseDataException();
        }
        int n2 = Integer.parseInt(string.substring(1, 2), 16);
        if ((n2 & 1) == 1) {
            string2 = string.substring(2, 2 + HOST_FIELD_LENGTH);
        }
        if ((n2 & 2) == 2) {
            string3 = string.substring(4, 4 + SYSINFO_FIELD_LENGTH);
        }
        if ((n2 & 4) == 4) {
            string4 = string.substring(11, 11 + MAC_FIELD_LENGTH);
        }
        if ((n2 & 8) == 8) {
            string5 = string.substring(15, 15 + HD_FIELD_LENGTH);
        }
        return new SystemId(n, string2, string3, string4, string5);
    }

    public SystemId(int n, String string, String string2, String string3, String string4) {
        this.D = n;
        this.C = PlatformUtil.isNullOrEmpty((String)string) || !SystemId.A(string) ? NO_HOST : string;
        this.B = PlatformUtil.isNullOrEmpty((String)string2) || !SystemId.A(string2) ? NO_SYSINFO : string2;
        this.E = PlatformUtil.isNullOrEmpty((String)string3) || !SystemId.A(string3) ? "0000" : string3;
        this.A = PlatformUtil.isNullOrEmpty((String)string4) || !SystemId.A(string4) ? "0000" : string4;
    }

    public boolean isNodeLocked() {
        return true;
    }

    public String getSystemInfo() {
        return this.A(this.B, SYSINFO_FIELD_LENGTH);
    }

    public boolean hasSystemInfo() {
        return !NO_SYSINFO.equals(this.getSystemInfo());
    }

    public String getMACAddr() {
        return this.A(this.E, MAC_FIELD_LENGTH);
    }

    public boolean hasMACAddr() {
        return !"0000".equals(this.getMACAddr());
    }

    public String getHDSerialId() {
        return this.A(this.A, HD_FIELD_LENGTH);
    }

    public boolean hasHDSerialId() {
        return !"0000".equals(this.getHDSerialId());
    }

    public String getHostInfo() {
        return this.A(this.C, HOST_FIELD_LENGTH);
    }

    public boolean hasHostInfo() {
        return !NO_HOST.equals(this.getHostInfo());
    }

    public String getCode() {
        int n = this.isNodeLocked() ? 1 : 2;
        int n2 = 0;
        n2 += this.hasHostInfo() ? 1 : 0;
        n2 += this.hasSystemInfo() ? 2 : 0;
        n2 += this.hasMACAddr() ? 4 : 0;
        String string = String.valueOf(Integer.toString(n, 16)) + Integer.toString(n2 += this.hasHDSerialId() ? 8 : 0, 16) + (this.hasHostInfo() ? this.getHostInfo() : SystemId.A(HOST_FIELD_LENGTH)) + (this.hasSystemInfo() ? this.getSystemInfo() : SystemId.A(SYSINFO_FIELD_LENGTH)) + (this.hasMACAddr() ? this.getMACAddr() : SystemId.A(MAC_FIELD_LENGTH)) + (this.hasHDSerialId() ? this.getHDSerialId() : SystemId.A(HD_FIELD_LENGTH));
        return string;
    }

    private static String A(int n) {
        StringBuffer stringBuffer = new StringBuffer(n);
        Random random = new Random();
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(Integer.toHexString(random.nextInt(16)));
            ++n2;
        }
        return stringBuffer.toString();
    }

    private static boolean A(String string) {
        if (PlatformUtil.isNullOrEmpty((String)string)) {
            return false;
        }
        int n = 0;
        while (n < string.length()) {
            String string2 = string.substring(n, n + 1);
            try {
                Byte.parseByte(string2, 16);
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean matches(SystemId systemId) {
        if (systemId == null) {
            return false;
        }
        if (this.hasHDSerialId() && systemId.hasHDSerialId() && this.getHDSerialId().equals(systemId.getHDSerialId())) {
            return true;
        }
        if (this.hasMACAddr() && systemId.hasMACAddr() && this.getMACAddr().equals(systemId.getMACAddr())) {
            return true;
        }
        if (this.hasHostInfo() && systemId.hasHostInfo() && this.getHostInfo().equals(systemId.getHostInfo())) {
            return true;
        }
        return this.hasSystemInfo() && systemId.hasSystemInfo() && this.getSystemInfo().equals(systemId.getSystemInfo());
    }

    private String A(String string, int n) {
        if (string == null || string.length() < n) {
            return SystemId.A(n);
        }
        if (string.length() == n) {
            return string;
        }
        return string.substring(0, n);
    }

    public static class InvalidLicenseDataException
    extends InvalidSystemDataException {
    }
}

