/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.server.core.util;

import com.genuitec.eclipse.core.GenuitecCoreException;
import com.genuitec.eclipse.server.core.ServerCorePlugin;
import com.genuitec.eclipse.server.core.util.IDynamicVariable;
import com.genuitec.eclipse.server.core.util.IVariableProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import org.eclipse.core.runtime.Plugin;

public class VariableSubstitutionEngine {
    private IVariableProvider provider;
    private static final String VARIABLE_START = "${";
    private static final char VARIABLE_END = '}';
    private static final char VARIABLE_ARG = ':';
    private static final int SCAN_FOR_START = 0;
    private static final int SCAN_FOR_END = 1;
    private StringBuffer fResult;
    private boolean fSubs;
    private Stack<VariableReference> fStack;
    private Map<String, IDynamicVariable> dynValues = new HashMap<String, IDynamicVariable>();

    public VariableSubstitutionEngine(IVariableProvider provider) {
        this.provider = provider;
    }

    protected IVariableProvider getVariableProvider() {
        return this.provider;
    }

    public synchronized String performStringSubstitution(String expression) throws GenuitecCoreException {
        return this.performStringSubstitution(expression, true, true);
    }

    private String performStringSubstitution(String expression, boolean reportUndefinedVariables, boolean resolveVariables) throws GenuitecCoreException {
        this.substitute(expression, reportUndefinedVariables, resolveVariables);
        ArrayList<HashSet<String>> resolvedVariableSets = new ArrayList<HashSet<String>>();
        while (this.fSubs) {
            HashSet<String> resolved = this.substitute(this.fResult.toString(), reportUndefinedVariables, true);
            int i = resolvedVariableSets.size() - 1;
            while (i >= 0) {
                HashSet prevSet = (HashSet)resolvedVariableSets.get(i);
                if (prevSet.equals(resolved)) {
                    HashSet conflictingSet = new HashSet();
                    while (i < resolvedVariableSets.size()) {
                        conflictingSet.addAll((Collection)resolvedVariableSets.get(i));
                        ++i;
                    }
                    StringBuffer problemVariableList = new StringBuffer();
                    Iterator it = conflictingSet.iterator();
                    while (it.hasNext()) {
                        problemVariableList.append((String)it.next());
                        problemVariableList.append(", ");
                    }
                    problemVariableList.setLength(problemVariableList.length() - 2);
                    throw new GenuitecCoreException("Variable {0} does not accept arguments", (Plugin)ServerCorePlugin.getDefault(), new String[]{problemVariableList.toString()});
                }
                --i;
            }
            resolvedVariableSets.add(resolved);
        }
        return this.fResult.toString();
    }

    private HashSet<String> substitute(String expression, boolean reportUndefinedVariables, boolean resolveVariables) throws GenuitecCoreException {
        this.fResult = new StringBuffer(expression.length());
        this.fStack = new Stack();
        this.fSubs = false;
        HashSet<String> resolvedVariables = new HashSet<String>();
        int pos = 0;
        int state = 0;
        while (pos < expression.length()) {
            switch (state) {
                case 0: {
                    int start = expression.indexOf(VARIABLE_START, pos);
                    if (start >= 0) {
                        int length = start - pos;
                        if (length > 0) {
                            this.fResult.append(expression.substring(pos, start));
                        }
                        pos = start + 2;
                        state = 1;
                        this.fStack.push(new VariableReference());
                        break;
                    }
                    this.fResult.append(expression.substring(pos));
                    pos = expression.length();
                    break;
                }
                case 1: {
                    VariableReference tos;
                    int start = expression.indexOf(VARIABLE_START, pos);
                    int end = expression.indexOf(125, pos);
                    if (end < 0) {
                        tos = this.fStack.peek();
                        tos.append(expression.substring(pos));
                        pos = expression.length();
                        break;
                    }
                    if (start >= 0 && start < end) {
                        int length = start - pos;
                        if (length > 0) {
                            VariableReference tos2 = this.fStack.peek();
                            tos2.append(expression.substring(pos, start));
                        }
                        pos = start + 2;
                        this.fStack.push(new VariableReference());
                        break;
                    }
                    tos = this.fStack.pop();
                    String substring = expression.substring(pos, end);
                    tos.append(substring);
                    resolvedVariables.add(substring);
                    pos = end + 1;
                    String value = this.resolve(tos, reportUndefinedVariables, resolveVariables);
                    if (value == null) {
                        value = "";
                    }
                    if (this.fStack.isEmpty()) {
                        this.fResult.append(value);
                        state = 0;
                        break;
                    }
                    tos = this.fStack.peek();
                    tos.append(value);
                }
            }
        }
        while (!this.fStack.isEmpty()) {
            VariableReference tos = this.fStack.pop();
            if (this.fStack.isEmpty()) {
                this.fResult.append(VARIABLE_START);
                this.fResult.append(tos.getText());
                continue;
            }
            VariableReference var = this.fStack.peek();
            var.append(VARIABLE_START);
            var.append(tos.getText());
        }
        return resolvedVariables;
    }

    private String resolve(VariableReference var, boolean reportUndefinedVariables, boolean resolveVariables) throws GenuitecCoreException {
        String valueVariable;
        String text = var.getText();
        int pos = text.indexOf(58);
        String name = null;
        String arg = null;
        if (pos > 0) {
            name = text.substring(0, pos);
            if (++pos < text.length()) {
                arg = text.substring(pos);
            }
        } else {
            name = text;
        }
        if ((valueVariable = this.provider.getStaticVariable(name)) == null) {
            IDynamicVariable dynamicVariable = this.getDynamicVariable(name);
            if (dynamicVariable == null) {
                if (reportUndefinedVariables) {
                    throw new GenuitecCoreException("Reference to undefined variable {0}", (Plugin)ServerCorePlugin.getDefault(), new String[]{name});
                }
                return this.getOriginalVarText(var);
            }
            if (resolveVariables) {
                this.fSubs = true;
                return dynamicVariable.getValue(arg);
            }
            return this.getOriginalVarText(var);
        }
        if (arg == null) {
            if (resolveVariables) {
                this.fSubs = true;
                return valueVariable;
            }
            return this.getOriginalVarText(var);
        }
        throw new GenuitecCoreException("Variable {0} does not accept arguments", (Plugin)ServerCorePlugin.getDefault(), new String[]{name});
    }

    private String getOriginalVarText(VariableReference var) {
        StringBuffer res = new StringBuffer(var.getText());
        res.insert(0, VARIABLE_START);
        res.append('}');
        return res.toString();
    }

    private IDynamicVariable getDynamicVariable(String name) {
        IDynamicVariable dynVar = this.dynValues.get(name);
        if (dynVar == null) {
            dynVar = this.provider.getDynamicVariable(name);
            this.dynValues.put(name, dynVar);
        }
        return dynVar;
    }

    class VariableReference {
        private StringBuffer fText = new StringBuffer();

        public void append(String text) {
            this.fText.append(text);
        }

        public String getText() {
            return this.fText.toString();
        }
    }
}

