/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.server.core.migration.internal;

import com.genuitec.eclipse.core.util.IndexedList;
import com.genuitec.eclipse.core.util.InitException;
import com.genuitec.eclipse.migration.core.IMigratingObject;
import com.genuitec.eclipse.migration.core.IMigratingObjectType;
import com.genuitec.eclipse.migration.core.MigrationPlugin;
import com.genuitec.eclipse.migration.core.internal.AbstractElementEnablement;
import com.genuitec.eclipse.migration.core.internal.IMigrationManager;
import com.genuitec.eclipse.migration.core.internal.MigratedObjectReferencesDetector;
import com.genuitec.eclipse.migration.core.internal.MigratingObject;
import com.genuitec.eclipse.migration.core.internal.MigratingObjectReferencesDetector;
import com.genuitec.eclipse.migration.core.internal.MigratingObjectType;
import com.genuitec.eclipse.migration.core.internal.MigrationCandidate;
import com.genuitec.eclipse.migration.core.internal.MigrationManagerImpl;
import com.genuitec.eclipse.migration.core.internal.MigrationOperation;
import com.genuitec.eclipse.migration.core.internal.MigrationOperationDef;
import com.genuitec.eclipse.migration.core.internal.MigrationPrioritizedObject;
import com.genuitec.eclipse.server.core.migration.ILegacyServer;
import com.genuitec.eclipse.server.core.migration.internal.Enablement;
import com.genuitec.eclipse.server.core.migration.internal.LegacyServersProvider;
import com.genuitec.eclipse.server.core.migration.internal.ServerMigrationCandidate;
import com.genuitec.eclipse.server.core.migration.internal.ServerMigrationOperation;
import com.genuitec.eclipse.server.core.migration.internal.UnknownServerType;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.codec.binary.Hex;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.Preferences;

public class ServerMigrationManager
implements IMigrationManager<ILegacyServer> {
    private static final String EXT_MIGRATION = "migration";
    private static final String EL_SERVERS_PROVIDER = "servers-provider";
    private static final String EL_SERVER_TYPE = "server-type";
    private static final String EL_MIGRATING_SERVER_REFERENCES_DETECTOR = "migrating-server-references-detector";
    private static final String EL_MIGRATION_OPERATION = "migration-operation";
    private static final String EL_MIGRATED_SERVER_REFERENCES_DETECTOR = "migrated-server-references-detector";
    private static ServerMigrationManager instance;
    private final Object lock = new Object();
    private List<LegacyServersProvider> providers;
    private List<MigratedObjectReferencesDetector<ILegacyServer>> migratedServersRefsDetectors;
    private List<MigratingObjectReferencesDetector<ILegacyServer>> migratingServersRefsDetectors;
    private IndexedList<String, MigratingObjectType<ILegacyServer>> serverTypes;
    private List<MigrationOperationDef<ILegacyServer>> serverMigrationOperations;
    private IEclipsePreferences rootNode;
    IEclipsePreferences.IPreferenceChangeListener changeListener = new IEclipsePreferences.IPreferenceChangeListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            String pluginId = event.getNode().name();
            if (ServerMigrationManager.this.providers != null) {
                for (LegacyServersProvider provider : ServerMigrationManager.this.providers) {
                    if (!provider.accept(pluginId)) continue;
                    for (ILegacyServer legacyServer : provider.getServers()) {
                        if (!legacyServer.isEnabled()) continue;
                        Object object = ServerMigrationManager.this.lock;
                        synchronized (object) {
                            ServerMigrationManager.this.legacyServers = null;
                        }
                        MigrationManagerImpl.getInstance().migrationCandidate((Object)legacyServer);
                    }
                }
            }
        }
    };
    private IEclipsePreferences.INodeChangeListener nodeChangeListener = new IEclipsePreferences.INodeChangeListener(){

        public void removed(IEclipsePreferences.NodeChangeEvent event) {
        }

        public void added(IEclipsePreferences.NodeChangeEvent event) {
            Preferences child = event.getChild();
            if (child.name().startsWith("com.genuitec.eclipse") && child instanceof IEclipsePreferences) {
                IEclipsePreferences pref = (IEclipsePreferences)child;
                pref.addPreferenceChangeListener(ServerMigrationManager.this.changeListener);
            }
        }
    };
    private String configurationHash;
    private List<ILegacyServer> legacyServers;

    public static ServerMigrationManager getInstance() {
        if (instance == null) {
            MigrationManagerImpl.getInstance();
        }
        return instance;
    }

    public ServerMigrationManager() {
        if (instance != null) {
            throw new RuntimeException("Only single ServerMigrationManager can be created");
        }
        instance = this;
        this.providers = new ArrayList<LegacyServersProvider>();
        this.migratedServersRefsDetectors = new ArrayList<MigratedObjectReferencesDetector<ILegacyServer>>();
        this.migratingServersRefsDetectors = new ArrayList<MigratingObjectReferencesDetector<ILegacyServer>>();
        this.serverTypes = new IndexedList();
        this.serverMigrationOperations = new ArrayList<MigrationOperationDef<ILegacyServer>>();
        this.rootNode = (IEclipsePreferences)Platform.getPreferencesService().getRootNode().node("instance");
        if (this.rootNode != null) {
            this.rootNode.addNodeChangeListener(this.nodeChangeListener);
        }
        this.readExtensionPoint();
        this.calculateHash();
    }

    private void readExtensionPoint() {
        IConfigurationElement[] elements;
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("com.genuitec.eclipse.server.core", EXT_MIGRATION);
        IConfigurationElement[] iConfigurationElementArray = elements = extensionPoint.getConfigurationElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            MigratingObjectType tmp;
            IConfigurationElement el = iConfigurationElementArray[n2];
            if (el.getName().equals(EL_SERVER_TYPE)) {
                try {
                    tmp = new MigratingObjectType((IMigrationManager)this, el);
                    this.serverTypes.addItemWithKey((Object)tmp.getType(), (Object)tmp);
                }
                catch (InitException initException) {}
            } else if (el.getName().equals(EL_MIGRATING_SERVER_REFERENCES_DETECTOR)) {
                try {
                    tmp = new MigratingObjectReferencesDetector((IMigrationManager)this, el);
                    this.migratingServersRefsDetectors.add((MigratingObjectReferencesDetector<ILegacyServer>)tmp);
                }
                catch (InitException initException) {}
            } else if (el.getName().equals(EL_MIGRATION_OPERATION)) {
                try {
                    tmp = new MigrationOperationDef((IMigrationManager)this, el);
                    this.serverMigrationOperations.add((MigrationOperationDef<ILegacyServer>)tmp);
                }
                catch (InitException initException) {}
            } else if (el.getName().equals(EL_MIGRATED_SERVER_REFERENCES_DETECTOR)) {
                try {
                    tmp = new MigratedObjectReferencesDetector((IMigrationManager)this, el);
                    this.migratedServersRefsDetectors.add((MigratedObjectReferencesDetector<ILegacyServer>)tmp);
                }
                catch (InitException initException) {}
            } else if (el.getName().equals(EL_SERVERS_PROVIDER)) {
                try {
                    this.providers.add(new LegacyServersProvider(el));
                }
                catch (InitException initException) {}
            }
            ++n2;
        }
        MigrationPrioritizedObject.PriorityComparator comparator = new MigrationPrioritizedObject.PriorityComparator();
        comparator.setText("Server types");
        this.serverTypes.sort((Comparator)comparator);
        comparator.setText("Server migration operations");
        Collections.sort(this.serverMigrationOperations, comparator);
        comparator.setText("Migrating server references detectors");
        Collections.sort(this.migratedServersRefsDetectors, comparator);
        comparator.setText("Migrated server references detectors");
        Collections.sort(this.migratedServersRefsDetectors, comparator);
        comparator.setText("Server providers");
        Collections.sort(this.providers, comparator);
    }

    private void calculateHash() {
        StringBuilder configuration = new StringBuilder();
        for (MigratingObjectType migratingObjectType : this.serverTypes.getItemList()) {
            configuration.append(String.valueOf(migratingObjectType.getType()) + "$:$" + migratingObjectType.getPriority() + "%$ ");
        }
        configuration.append("$_$_$ ");
        for (MigrationOperationDef migrationOperationDef : this.serverMigrationOperations) {
            configuration.append(String.valueOf(migrationOperationDef.getType()) + "$:$" + migrationOperationDef.getVersion() + "%$ ");
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.reset();
            messageDigest.update(configuration.toString().getBytes("UTF-8"));
            byte[] resultByte = messageDigest.digest();
            this.configurationHash = new String(Hex.encodeHex((byte[])resultByte));
        }
        catch (Exception exception) {
            MigrationPlugin.getDefault().log("Exception while creating configuration hash.", (Throwable)exception);
            this.configurationHash = null;
        }
    }

    public boolean accepts(Object object) {
        return object instanceof ILegacyServer;
    }

    public void refreshMigrationAutodetectSettings(boolean isAutoDetect) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ILegacyServer> getAllObjects() {
        Object object = this.lock;
        synchronized (object) {
            if (this.legacyServers == null) {
                this.legacyServers = new ArrayList<ILegacyServer>();
                for (LegacyServersProvider provider : this.providers) {
                    this.legacyServers.addAll(provider.getServers());
                }
                this.legacyServers = Collections.unmodifiableList(this.legacyServers);
            }
        }
        return this.legacyServers;
    }

    public String getConfigurationHash() {
        return this.configurationHash;
    }

    public MigrationCandidate<ILegacyServer> createMigrationCandidate(ILegacyServer object) {
        return new ServerMigrationCandidate(object);
    }

    public AbstractElementEnablement createElementEnablement(IConfigurationElement iConfigurationElement, int filterFlags) throws InitException {
        return new Enablement(iConfigurationElement, filterFlags);
    }

    public MigrationOperation<ILegacyServer> createMigrationOperation(MigrationOperationDef<ILegacyServer> def, MigratingObject<ILegacyServer> object) throws CoreException {
        return new ServerMigrationOperation(def, (IMigratingObject<ILegacyServer>)object);
    }

    public List<MigrationOperationDef<ILegacyServer>> getMigrationOperationDefs() {
        return this.serverMigrationOperations;
    }

    public List<MigratingObjectType<ILegacyServer>> getObjectTypes() {
        return this.serverTypes.getItemList();
    }

    public IMigratingObjectType<ILegacyServer> getObjectType(String objectType) {
        return (IMigratingObjectType)this.serverTypes.getItemByKey((Object)objectType);
    }

    public IMigratingObjectType<ILegacyServer> unknownObjectType() {
        return UnknownServerType.instance();
    }

    public List<MigratedObjectReferencesDetector<ILegacyServer>> getMigratedObjectReferencesDetectors() {
        return this.migratedServersRefsDetectors;
    }

    public List<MigratingObjectReferencesDetector<ILegacyServer>> getMigratingObjectReferencesDetectors() {
        return this.migratingServersRefsDetectors;
    }
}

