/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.server.core.migration.internal;

import com.genuitec.eclipse.core.util.InitException;
import com.genuitec.eclipse.core.util.Util;
import com.genuitec.eclipse.migration.core.internal.AbstractElementEnablement;
import com.genuitec.eclipse.migration.core.internal.MigratingObject;
import com.genuitec.eclipse.migration.core.internal.MigrationUtils;
import com.genuitec.eclipse.server.core.ServerCorePlugin;
import com.genuitec.eclipse.server.core.migration.ILegacyServer;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.server.core.ServerCore;
import org.osgi.framework.Bundle;

public class Enablement
extends AbstractElementEnablement {
    private static final String EL_INSTANCE_OF = "instance-of";
    private static final String EL_TARGET_NOT_EXISTS = "target-not-exists";

    public Enablement(IConfigurationElement iConfigurationElement, int filterFlags) throws InitException {
        super(iConfigurationElement, filterFlags);
    }

    protected void initializeFiltersMap(Map<String, Class<? extends AbstractElementEnablement.IFilter>> el2class) {
        super.initializeFiltersMap(el2class);
        el2class.put(EL_INSTANCE_OF, InstanceOf.class);
        el2class.put(EL_TARGET_NOT_EXISTS, TargetNotExists.class);
    }

    private static class InstanceOf
    implements AbstractElementEnablement.IFilter {
        private Class<?> clazz;

        public InstanceOf(IConfigurationElement element) throws InitException {
            String clName = element.getAttribute("class");
            if (clName == null) {
                MigrationUtils.reportMissingAttribute((IConfigurationElement)element, (String)"class");
                throw new InitException();
            }
            Bundle b = Platform.getBundle((String)element.getContributor().getName());
            if (b == null) {
                ServerCorePlugin.getDefault().log("Cannot acquire bundle interface for {0}.", new String[]{element.getContributor().getName()});
                throw new InitException();
            }
            try {
                this.clazz = b.loadClass(clName);
            }
            catch (Exception e) {
                ServerCorePlugin.getDefault().log(e);
            }
            if (this.clazz == null) {
                ServerCorePlugin.getDefault().log("Cannot load class {0} from bundle {1} specified by <{2}> element.", new String[]{clName, element.getContributor().getName(), element.getName()});
                throw new InitException();
            }
        }

        public boolean isApplicable(MigratingObject<?> mo) {
            return this.clazz.isInstance(mo.getObject());
        }

        public String toString() {
            return "[instanceof='" + this.clazz + "']";
        }
    }

    private static class TargetNotExists
    implements AbstractElementEnablement.IFilter {
        boolean isRuntime;

        public TargetNotExists(IConfigurationElement element) throws InitException {
            String type = element.getAttribute("type");
            if (Util.isNullOrEmpty((String)type)) {
                MigrationUtils.reportMissingAttribute((IConfigurationElement)element, (String)"type");
                throw new InitException();
            }
            if ("runtime".equals(type)) {
                this.isRuntime = true;
            } else if ("server".equals(type)) {
                this.isRuntime = false;
            } else {
                ServerCorePlugin.getDefault().log("Incorrect target type: {0} in plugin {1}. Only 'server' and 'runtime' are allowed.", new String[]{type, element.getContributor().getName()});
            }
        }

        public boolean isApplicable(MigratingObject<?> object) {
            ILegacyServer server = (ILegacyServer)object.getObject();
            return this.isRuntime ? ServerCore.findRuntime((String)server.getTargetRuntimeId()) == null : ServerCore.findServer((String)server.getTargetServerId()) == null;
        }
    }
}

