/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.server.core.legacy.migration.internal.simple;

import com.genuitec.eclipse.core.util.InitException;
import com.genuitec.eclipse.core.util.Util;
import com.genuitec.eclipse.migration.core.MigrationPlugin;
import com.genuitec.eclipse.migration.core.internal.MigrationUtils;
import com.genuitec.eclipse.server.core.legacy.migration.ISimpleEASIEServer;
import com.genuitec.eclipse.server.core.legacy.migration.internal.simple.SimpleEASIEServerAbstractMigrationSpec;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.internal.runtime.AdapterManager;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.ServerCore;

public class SimpleEASIEServer
extends SimpleEASIEServerAbstractMigrationSpec
implements ISimpleEASIEServer {
    private static final String ATTR_EASIE_PLUGIN_ID = "easie-plugin-id";
    private static final String ATTR_WTP_SERVER_TYPE = "wtp-server-type";
    private static final String ATTR_EASIE_SERVER_ID = "easie-server-id";
    private static final String ATTR_NAME = "name";
    private static final String PROPERTY_PREFIX = "migration.";
    private String easiePluginId;
    private String easieServerId;
    private String name;
    private IServerType wtpTargetServerType;
    private IEclipsePreferences prefs;
    private Map<String, String> prefsToMigrateCache;

    public SimpleEASIEServer(IConfigurationElement element) throws InitException {
        super(element);
        this.name = element.getAttribute(ATTR_NAME);
        if (Util.isNullOrEmpty((String)this.name)) {
            MigrationUtils.reportMissingAttribute((IConfigurationElement)element, (String)ATTR_NAME);
            throw new InitException();
        }
        this.easiePluginId = element.getAttribute(ATTR_EASIE_PLUGIN_ID);
        if (Util.isNullOrEmpty((String)this.easiePluginId)) {
            MigrationUtils.reportMissingAttribute((IConfigurationElement)element, (String)ATTR_EASIE_PLUGIN_ID);
            throw new InitException();
        }
        this.prefs = InstanceScope.INSTANCE.getNode(this.easiePluginId);
        this.easieServerId = element.getAttribute(ATTR_EASIE_SERVER_ID);
        if (Util.isNullOrEmpty((String)this.easieServerId)) {
            MigrationUtils.reportMissingAttribute((IConfigurationElement)element, (String)ATTR_EASIE_SERVER_ID);
            throw new InitException();
        }
        String serverType = element.getAttribute(ATTR_WTP_SERVER_TYPE);
        if (Util.isNullOrEmpty((String)serverType)) {
            MigrationUtils.reportMissingAttribute((IConfigurationElement)element, (String)ATTR_WTP_SERVER_TYPE);
            throw new InitException();
        }
        this.wtpTargetServerType = ServerCore.findServerType((String)serverType);
    }

    @Override
    public boolean isAbstract() {
        return false;
    }

    @Override
    public String getName() {
        return this.wtpTargetServerType != null ? this.wtpTargetServerType.getName() : this.name;
    }

    @Override
    public Map<String, String> getPreferencesToMigrate() {
        if (this.prefsToMigrateCache == null) {
            this.prefsToMigrateCache = new HashMap<String, String>();
            this.fillPrefsToMigrate(this.prefsToMigrateCache);
            this.prefsToMigrateCache = Collections.unmodifiableMap(this.prefsToMigrateCache);
        }
        return this.prefsToMigrateCache;
    }

    @Override
    public String getEASIEPluginId() {
        return this.easiePluginId;
    }

    @Override
    public String getEASIEServerId() {
        return this.easieServerId;
    }

    @Override
    public String getMigrationProperty(String property, String defaultValue) {
        return this.prefs.get(PROPERTY_PREFIX + property, defaultValue);
    }

    @Override
    public void setMigrationProperty(String property, String value) {
        this.prefs.put(PROPERTY_PREFIX + property, value);
        try {
            this.prefs.flush();
        }
        catch (Exception e) {
            MigrationPlugin.getDefault().log("Failed to save preferences change", (Throwable)e);
        }
    }

    @Override
    public boolean isEnabled() {
        return Boolean.parseBoolean(this.prefs.get("SERVER_ENABLEMENT", null));
    }

    @Override
    public IServerType getTargetServerType() {
        return this.wtpTargetServerType;
    }

    @Override
    public String getTargetServerId() {
        return this.easiePluginId;
    }

    @Override
    public String getTargetRuntimeId() {
        IRuntimeType rt = this.wtpTargetServerType.getRuntimeType();
        return rt.getName();
    }

    public Object getAdapter(Class adapter) {
        return AdapterManager.getDefault().loadAdapter((Object)this, adapter.getName());
    }
}

