/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.server.core.internal;

import com.genuitec.eclipse.server.core.IGenuitecServer;
import com.genuitec.eclipse.server.core.IGenuitecServerLaunchConfig;
import com.genuitec.eclipse.server.core.IGenuitecServerLaunchConfigCustomizer;
import com.genuitec.eclipse.server.core.ServerCorePlugin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

public class LaunchConfigCustomizersManager {
    private static final String EXT_CUSTOMIZERS = "launchConfigCustomizers";
    private static final String EL_CUSTOMIZER = "customizer";
    private static final String ATTR_CLASS = "class";
    private static final String ASTERISK = "*";
    private static final String ATT_TYPE_IDS = "typeIds";
    private static final String ATT_TYPE_IDS_SEP = ",";
    private static final Map<IGenuitecServerLaunchConfigCustomizer, String[]> customizersMap;

    static {
        IConfigurationElement[] elements;
        customizersMap = new HashMap<IGenuitecServerLaunchConfigCustomizer, String[]>();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("com.genuitec.eclipse.server.core", EXT_CUSTOMIZERS);
        IConfigurationElement[] iConfigurationElementArray = elements = extensionPoint.getConfigurationElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement el = iConfigurationElementArray[n2];
            if (el.getName().equals(EL_CUSTOMIZER)) {
                try {
                    customizersMap.put((IGenuitecServerLaunchConfigCustomizer)el.createExecutableExtension(ATTR_CLASS), LaunchConfigCustomizersManager.getTypeIds(el));
                }
                catch (CoreException e) {
                    ServerCorePlugin.getDefault().log(e);
                }
            }
            ++n2;
        }
    }

    public static IGenuitecServerLaunchConfig customizeConfig(IGenuitecServer server, IGenuitecServerLaunchConfig config) {
        String typeId = server.getServer().getServerType().getId();
        Set<IGenuitecServerLaunchConfigCustomizer> customizers = customizersMap.keySet();
        for (IGenuitecServerLaunchConfigCustomizer customizer : customizers) {
            if (!LaunchConfigCustomizersManager.isSupported(customizersMap.get(customizer), typeId)) continue;
            config = customizer.customizeLaunchConfig(server, config);
        }
        return config;
    }

    private static String[] getTypeIds(IConfigurationElement element) {
        String typeIds = element.getAttribute(ATT_TYPE_IDS);
        if (typeIds != null) {
            try {
                ArrayList<String> list = new ArrayList<String>();
                StringTokenizer st = new StringTokenizer(typeIds, ATT_TYPE_IDS_SEP);
                while (st.hasMoreTokens()) {
                    String str = st.nextToken();
                    if (str == null || str.length() <= 0) continue;
                    list.add(str.trim());
                }
                String[] s = new String[list.size()];
                list.toArray(s);
                return s;
            }
            catch (Exception e) {
                ServerCorePlugin.getDefault().log(e);
            }
        }
        return new String[]{ASTERISK};
    }

    private static boolean isSupported(String[] typeIds, String id) {
        int size = typeIds.length;
        int i = 0;
        while (i < size) {
            String typeId = typeIds[i];
            if (typeId.endsWith(ASTERISK) ? id.length() >= typeId.length() && id.startsWith(typeId.substring(0, typeId.length() - 1)) : id.equals(typeId)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

