/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.server.core;

import com.genuitec.eclipse.core.GenuitecCoreException;
import com.genuitec.eclipse.server.core.IGenuitecServerLaunchConfig;
import com.genuitec.eclipse.server.core.IGenuitecServerLaunchConfigProvider;
import com.genuitec.eclipse.server.core.ServerCorePlugin;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.StandardClasspathProvider;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerUtil;

public class ServerLaunchClasspathProvider
extends StandardClasspathProvider {
    public static final String ID = "com.genuitec.server.classpathProvider";

    public IRuntimeClasspathEntry[] computeUnresolvedClasspath(ILaunchConfiguration configuration) throws CoreException {
        boolean useDefault = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, true);
        if (useDefault) {
            IServer server = ServerUtil.getServer((ILaunchConfiguration)configuration);
            if (server == null) {
                throw new GenuitecCoreException("Could not find server for the launch configuration", (Plugin)ServerCorePlugin.getDefault(), new String[0]);
            }
            IGenuitecServerLaunchConfigProvider provider = (IGenuitecServerLaunchConfigProvider)server.loadAdapter(IGenuitecServerLaunchConfigProvider.class, null);
            if (provider == null) {
                throw new GenuitecCoreException("Server does not provide IGenuitecServerLaunchConfigProvider adapter", (Plugin)ServerCorePlugin.getDefault(), new String[0]);
            }
            IGenuitecServerLaunchConfig config = provider.getServerLaunchConfig(configuration);
            if (config == null) {
                throw new GenuitecCoreException("Server does not provide IGenuitecServerLaunchConfig", (Plugin)ServerCorePlugin.getDefault(), new String[0]);
            }
            ArrayList<IRuntimeClasspathEntry> classpath = new ArrayList<IRuntimeClasspathEntry>(config.getLaunchClasspath());
            IVMInstall vmInstall = config.getLaunchVMInstall();
            if (vmInstall != null) {
                IPath toolsPath;
                String typeId = vmInstall.getVMInstallType().getId();
                classpath.add(0, JavaRuntime.newRuntimeContainerClasspathEntry((IPath)new Path(JavaRuntime.JRE_CONTAINER).append(typeId).append(vmInstall.getName()), (int)2));
                if (config.launchRequiresToolsJar() && (toolsPath = new Path(vmInstall.getInstallLocation().getAbsolutePath()).append("lib").append("tools.jar")).toFile().exists()) {
                    classpath.add(1, JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)toolsPath));
                }
            }
            return classpath.toArray(new IRuntimeClasspathEntry[classpath.size()]);
        }
        return this.recoverRuntimePath(configuration, IJavaLaunchConfigurationConstants.ATTR_CLASSPATH);
    }
}

