/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.server.core;

import com.genuitec.eclipse.core.GenuitecCoreException;
import com.genuitec.eclipse.server.core.BaseServerLaunchConfig;
import com.genuitec.eclipse.server.core.IGenuitecServer;
import com.genuitec.eclipse.server.core.internal.ServerArgumentsSubstitutionEngine;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;

public class GenuitecServerLaunchConfig
extends BaseServerLaunchConfig {
    private final String launchWorkingDir;
    private final String[] launchVMArgs;
    private final String[] launchClasspath;
    private final String launchMainClass;
    private final String[] launchProgramArgs;
    private final ServerArgumentsSubstitutionEngine engine;
    private final String[] envVars;
    private final boolean replaceEnvironment;

    public GenuitecServerLaunchConfig(IGenuitecServer server, String launchWorkingDir, String[] launchVMArgs, String[] launchClasspath, String launchMainClass, String[] launchProgramArgs) {
        super(server);
        this.launchWorkingDir = launchWorkingDir;
        this.launchVMArgs = launchVMArgs;
        this.launchClasspath = launchClasspath;
        this.launchMainClass = launchMainClass;
        this.launchProgramArgs = launchProgramArgs;
        this.engine = new ServerArgumentsSubstitutionEngine(server);
        this.envVars = null;
        this.replaceEnvironment = false;
    }

    public GenuitecServerLaunchConfig(IGenuitecServer server, String launchWorkingDir, String[] launchVMArgs, String[] launchClasspath, String launchMainClass, String[] launchProgramArgs, String[] envVars, boolean replaceSystemEnv) {
        super(server);
        assert (envVars.length % 2 == 0);
        this.launchWorkingDir = launchWorkingDir;
        this.launchVMArgs = launchVMArgs;
        this.launchClasspath = launchClasspath;
        this.launchMainClass = launchMainClass;
        this.launchProgramArgs = launchProgramArgs;
        this.engine = new ServerArgumentsSubstitutionEngine(server);
        this.envVars = envVars;
        this.replaceEnvironment = replaceSystemEnv;
    }

    @Override
    public String[] getLaunchProgramArguments() throws CoreException {
        return this.substituteArray(this.launchProgramArgs);
    }

    @Override
    public String[] getLaunchVMArguments() throws CoreException {
        return this.substituteArray(this.launchVMArgs);
    }

    @Override
    public String getLaunchMainClass() throws CoreException {
        return this.engine.performStringSubstitution(this.launchMainClass);
    }

    @Override
    public String getLaunchWorkingDirectory() throws CoreException {
        return this.engine.performStringSubstitution(this.launchWorkingDir);
    }

    @Override
    public boolean launchRequiresToolsJar() throws CoreException {
        return false;
    }

    @Override
    public Map<String, String> getEnvironmentVars() throws CoreException {
        if (this.envVars != null) {
            HashMap<String, String> result = new HashMap<String, String>();
            int i = 0;
            while (i < this.envVars.length) {
                String var = this.envVars[i];
                String value = this.envVars[i + 1];
                result.put(var, this.engine.performStringSubstitution(value));
                i += 2;
            }
            return result;
        }
        return null;
    }

    @Override
    public boolean shouldReplaceSystemEnvVars() {
        return this.replaceEnvironment;
    }

    @Override
    protected String[] internalGetLaunchClasspath() throws CoreException {
        return this.substituteArray(this.launchClasspath);
    }

    private String[] substituteArray(String[] array) throws GenuitecCoreException {
        String[] res = Arrays.copyOf(array, array.length);
        int i = 0;
        while (i < res.length) {
            res[i] = this.engine.performStringSubstitution(res[i]);
            ++i;
        }
        return res;
    }
}

