/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.server.core;

import com.genuitec.eclipse.runtime.wtp.GenuitecRuntimeDelegate;
import com.genuitec.eclipse.server.core.GenuitecAppServer;
import com.genuitec.eclipse.server.core.GenuitecServerBehaviour;
import com.genuitec.eclipse.server.core.ServerCorePlugin;
import com.genuitec.eclipse.server.core.deployment.DeploymentUtils;
import com.genuitec.eclipse.server.core.deployment.IDeploymentProcessorFactory;
import com.genuitec.eclipse.server.core.deployment.ModuleArchiver;
import com.genuitec.eclipse.server.core.deployment.ModuleDeployer;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServerListener;
import org.eclipse.wst.server.core.ServerEvent;
import org.eclipse.wst.server.core.model.DeployMode;
import org.eclipse.wst.server.core.model.IModuleDeploymentBehaviourDelegate;
import org.eclipse.wst.server.core.model.IPublishedModuleDeployment;
import org.eclipse.wst.server.core.model.ModuleDeltaKind;
import org.eclipse.wst.server.core.model.ModulePublishState;
import org.eclipse.wst.server.core.model.PublishDeltaKind;

public abstract class GenuitecAppServerBehaviour
extends GenuitecServerBehaviour
implements IModuleDeploymentBehaviourDelegate,
IDeploymentProcessorFactory {
    private boolean ignoreModulePublishStateChange;

    @Override
    protected void initialize(IProgressMonitor monitor) {
        super.initialize(monitor);
        this.getServer().addServerListener(new IServerListener(){

            public void serverChanged(ServerEvent event) {
                if (GenuitecAppServerBehaviour.this.ignoreModulePublishStateChange) {
                    return;
                }
                GenuitecAppServerBehaviour.this.ignoreModulePublishStateChange = true;
                try {
                    GenuitecAppServerBehaviour.this.propagateModuleState(event.getModule());
                }
                finally {
                    GenuitecAppServerBehaviour.this.ignoreModulePublishStateChange = false;
                }
            }
        }, 34);
    }

    protected void publishServer(int kind, IProgressMonitor monitor) throws CoreException {
        this.setServerPublishState(1);
    }

    protected boolean supportsPerModuleDeployment() {
        return true;
    }

    public IStatus canStart(String launchMode) {
        return launchMode != null && (launchMode.equals("run") || launchMode.equals("debug")) ? Status.OK_STATUS : Status.CANCEL_STATUS;
    }

    @Override
    protected void validateSetup() throws CoreException {
        IStatus status = this.getGenuitecRuntime().validate();
        if (status != null && status.getSeverity() == 4) {
            throw new CoreException(status);
        }
        super.validateSetup();
    }

    public void publishDeployment(PublishDeltaKind publishDelta, IPublishedModuleDeployment rootDeployment, IProgressMonitor m) throws CoreException {
        this.validateSetup();
        MultiStatus status = new MultiStatus("com.genuitec.eclipse.server.core", 0, MessageFormat.format("There were issues during deployment to server {0}. See Error Log for details.", this.getServer().getName()), null);
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)m, (int)1000);
        this.ignoreModulePublishStateChange = true;
        try {
            try {
                this.cleanStatus(rootDeployment);
                try {
                    this.internalPublishDeployment(publishDelta, rootDeployment, monitor.newChild(900), status);
                }
                finally {
                    this.propagateModuleState(rootDeployment);
                }
                IStatus moduleStatus = rootDeployment.getModuleStatus();
                if (moduleStatus != null && status.getSeverity() < rootDeployment.getModuleStatus().getSeverity()) {
                    status.add(moduleStatus);
                }
                if (status.getSeverity() > 0) {
                    ServerCorePlugin.getDefault().log((IStatus)status);
                    if (status.getSeverity() >= 4) {
                        throw new CoreException((IStatus)status);
                    }
                }
                this.afterDeploymentPublish(publishDelta, rootDeployment, monitor.newChild(100));
            }
            catch (CoreException ce) {
                this.setModulePublishState(rootDeployment.getModulePath(), 3);
                MultiStatus status2 = new MultiStatus("com.genuitec.eclipse.server.core", 0, new IStatus[]{ce.getStatus()}, "Deployment failed", (Throwable)ce);
                this.setModuleStatus(rootDeployment.getModulePath(), (IStatus)status2);
                throw ce;
            }
            catch (Exception e) {
                this.setModulePublishState(rootDeployment.getModulePath(), 3);
                MultiStatus status2 = new MultiStatus("com.genuitec.eclipse.server.core", 0, new IStatus[]{new Status(4, "com.genuitec.eclipse.server.core", e.getLocalizedMessage(), (Throwable)e)}, "Deployment failed", null);
                this.setModuleStatus(rootDeployment.getModulePath(), (IStatus)status2);
                throw new CoreException((IStatus)status2);
            }
        }
        finally {
            this.ignoreModulePublishStateChange = false;
            monitor.done();
        }
    }

    protected void afterDeploymentPublish(PublishDeltaKind publishDelta, IPublishedModuleDeployment rootDeployment, SubMonitor newChild) throws CoreException {
    }

    private void cleanStatus(IPublishedModuleDeployment deployment) {
        deployment.setModuleStatus(null);
        for (IPublishedModuleDeployment pmd : deployment.getChildDeployments()) {
            this.cleanStatus(pmd);
        }
    }

    private void propagateModuleState(IModule[] module) {
        int maxPublishState = 0;
        while (module.length > 0) {
            int curState = this.getServer().getModulePublishState(module);
            if (curState < maxPublishState) {
                this.setModulePublishState(module, maxPublishState);
            } else {
                maxPublishState = curState;
            }
            module = Arrays.copyOf(module, module.length - 1);
        }
    }

    private ModulePublishState propagateModuleState(IPublishedModuleDeployment deployment) {
        ModulePublishState curState = deployment.getModulePublishState();
        int severity = 0;
        for (IPublishedModuleDeployment child : deployment.getChildDeployments()) {
            IStatus status;
            ModulePublishState childState = this.propagateModuleState(child);
            if (childState.ordinal() > curState.ordinal()) {
                curState = childState;
            }
            if ((status = child.getModuleStatus()) == null || status.getSeverity() <= severity) continue;
            severity = status.getSeverity();
        }
        IStatus status = deployment.getModuleStatus();
        if (severity >= 4 && (status == null || status.getSeverity() < 4)) {
            status = new MultiStatus("com.genuitec.eclipse.server.core", 0, new IStatus[]{new Status(4, "com.genuitec.eclipse.server.core", "Child module deployment failed")}, "Deployment failed", null);
            deployment.setModuleStatus(status);
        }
        deployment.setModulePublishState(curState);
        return curState;
    }

    protected void internalPublishDeployment(PublishDeltaKind publishDelta, IPublishedModuleDeployment rootDeployment, SubMonitor monitor, MultiStatus status) throws CoreException {
        String location;
        monitor.beginTask("", 1002);
        if (rootDeployment.getLocation() != null && publishDelta == PublishDeltaKind.PUBLISH_CLEAN) {
            DeploymentUtils.deleteDeployment(rootDeployment, monitor.newChild(100), status);
        }
        if ((publishDelta = DeploymentUtils.processChildDeployment(publishDelta, rootDeployment, location = this.getDeploymentLocation(rootDeployment), monitor.newChild(100), status)) == null) {
            rootDeployment.setModulePublishState(ModulePublishState.PUBLISH_STATE_NONE);
            rootDeployment.setModuleStatus(null);
            return;
        }
        DeployMode mode = this.getDeploymentDeployMode(publishDelta, rootDeployment);
        if (mode == DeployMode.PACKAGED) {
            if (rootDeployment.getModuleDeltaKind() != ModuleDeltaKind.NO_CHANGE && publishDelta == PublishDeltaKind.PUBLISH_AUTO) {
                rootDeployment.setModulePublishState(ModulePublishState.PUBLISH_STATE_INCREMENTAL);
                rootDeployment.setModuleStatus(null);
            } else {
                DeploymentUtils.publishZip(this, publishDelta, rootDeployment, DeploymentUtils.getModuleDeploymentPhysicalLocation(rootDeployment), Collections.<IVirtualComponent>emptyList(), monitor.newChild(999), status);
            }
        } else if (mode == DeployMode.EXPLODED) {
            ModuleDeployer deployer = this.createModuleDeployer(publishDelta, rootDeployment, status);
            deployer.processDeployment(monitor.newChild(990));
        } else {
            status.add(ServerCorePlugin.createStatus(4, "Deployment {0} has unsupported deploy mode {1}.", rootDeployment.toString(), rootDeployment.getDeployMode()));
        }
        monitor.worked(1);
    }

    protected DeployMode getDeploymentDeployMode(PublishDeltaKind publishDelta, IPublishedModuleDeployment rootDeployment) throws CoreException {
        return rootDeployment.getDeployMode();
    }

    @Override
    public ModuleDeployer createModuleDeployer(PublishDeltaKind publishDelta, IPublishedModuleDeployment rootDeployment, MultiStatus status) throws CoreException {
        return new ModuleDeployer(this, publishDelta, rootDeployment, status);
    }

    @Override
    public ModuleArchiver createModuleArchiver(IPublishedModuleDeployment deployment, OutputStream out, MultiStatus status) throws CoreException {
        return new ModuleArchiver(this, deployment, out, status);
    }

    protected abstract String getDeploymentLocation(IPublishedModuleDeployment var1) throws CoreException;

    @Override
    public String toString() {
        try {
            return String.valueOf(this.getClass().toString()) + "[" + this.getServer().getId() + "][" + this.getGenuitecRuntime().getRuntime().getLocation().toString() + "]";
        }
        catch (NullPointerException nullPointerException) {
            return String.valueOf(this.getClass().toString()) + "[" + this.getServer().getId() + "]";
        }
    }

    public void handleResourceChange() {
        super.handleResourceChange();
    }

    public GenuitecRuntimeDelegate getGenuitecRuntime() {
        if (this.getServer().getRuntime() == null) {
            return null;
        }
        return (GenuitecRuntimeDelegate)this.getServer().getRuntime().loadAdapter(GenuitecRuntimeDelegate.class, null);
    }

    public GenuitecAppServer getGenuitecAppServer() {
        return (GenuitecAppServer)this.getServer().getAdapter(GenuitecAppServer.class);
    }
}

