/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.j2eedt.facet.ui.internal;

import com.genuitec.eclipse.core.util.InitException;
import com.genuitec.eclipse.j2eedt.facet.ui.internal.FacetConfiguration;
import com.genuitec.eclipse.j2eedt.ui.J2EEUICore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.common.project.facet.core.JavaFacet;
import org.eclipse.jst.common.project.facet.core.internal.JavaFacetDetector;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class GenericFacetInstallationManagerImpl {
    private static final String EXT_GENERIC_FACET_INSTALL = "genericFacetInstall";
    private static final String ELEM_FACET = "facet";
    private static Map<IProjectFacet, FacetConfiguration> facetConfigs = new HashMap<IProjectFacet, FacetConfiguration>();
    private static List<FacetConfiguration> installableConfigs = new ArrayList<FacetConfiguration>();

    static {
        GenericFacetInstallationManagerImpl.readGenericFacetInstallExtension();
    }

    private GenericFacetInstallationManagerImpl() {
    }

    public static FacetConfiguration getFacetConfiguration(IProjectFacet mainFacet) {
        FacetConfiguration config = facetConfigs.get(mainFacet);
        if (config == null) {
            throw new RuntimeException("Facet " + mainFacet.getId() + " does not have generic install configuration specified");
        }
        return config;
    }

    private static void readGenericFacetInstallExtension() {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("com.genuitec.eclipse.j2eedt.core", EXT_GENERIC_FACET_INSTALL);
        IConfigurationElement[] elements = extensionPoint.getConfigurationElements();
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            if (ce.getName().equals(ELEM_FACET)) {
                try {
                    FacetConfiguration config = new FacetConfiguration(ce);
                    facetConfigs.put(config.getFacet(), config);
                }
                catch (InitException initException) {}
            }
            ++n2;
        }
        HashSet<FacetConfiguration> processed = new HashSet<FacetConfiguration>();
        Stack<FacetConfiguration> stack = new Stack<FacetConfiguration>();
        for (FacetConfiguration fc : facetConfigs.values()) {
            if (processed.contains(fc)) continue;
            stack.push(fc);
            while (!stack.isEmpty()) {
                FacetConfiguration cur = (FacetConfiguration)stack.pop();
                FacetConfiguration notProcessed = cur.root.getUnprocessedDependency(processed);
                if (notProcessed != null) {
                    if (stack.contains(notProcessed)) {
                        J2EEUICore.getDefault().log("Circular dependency in generic facet engine. Error for " + notProcessed.getFacet().getId());
                        return;
                    }
                    stack.push(cur);
                    stack.push(notProcessed);
                    continue;
                }
                cur.root = (FacetConfiguration.AndExpr)cur.root.addDependencies();
                processed.add(cur);
            }
        }
        for (FacetConfiguration fc : facetConfigs.values()) {
            if (!fc.isInstallable()) continue;
            installableConfigs.add(fc);
        }
        Collections.sort(installableConfigs, new Comparator<FacetConfiguration>(){

            @Override
            public int compare(FacetConfiguration o1, FacetConfiguration o2) {
                return o1.getFacet().getLabel().compareToIgnoreCase(o2.getFacet().getLabel());
            }
        });
    }

    public static List<IProjectFacet> getInstallableFacets(IProject project) {
        HashSet<IProjectFacetVersion> facets;
        block3: {
            facets = null;
            try {
                IFacetedProject fp = ProjectFacetsManager.create((IProject)project);
                facets = fp.getProjectFacets();
            }
            catch (Exception exception) {
                IProjectFacetVersion javaVer = JavaFacetDetector.detectJavaFacetVersion((IProject)project, (IProjectFacetVersion)JavaFacet.FACET.getDefaultVersion());
                facets = new HashSet<IProjectFacetVersion>();
                if (javaVer == null) break block3;
                facets.add(javaVer);
            }
        }
        ArrayList<IProjectFacet> result = new ArrayList<IProjectFacet>();
        for (FacetConfiguration fc : installableConfigs) {
            if (!fc.canInstall(facets)) continue;
            result.add(fc.getFacet());
        }
        return result;
    }
}

