/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.j2eedt.facet.ui.command;

import com.genuitec.eclipse.core.GenuitecCoreException;
import com.genuitec.eclipse.core.util.UIUtil;
import com.genuitec.eclipse.j2eedt.facet.ui.GenericInstallFacetWizard;
import com.genuitec.eclipse.j2eedt.facet.ui.internal.GenericFacetInstallationManagerImpl;
import com.genuitec.eclipse.j2eedt.ui.J2EEUICore;
import com.genuitec.eclipse.migration.core.IMigratingObject;
import com.genuitec.eclipse.migration.core.IMigrationCandidate;
import com.genuitec.eclipse.migration.core.MigratingObjectState;
import com.genuitec.eclipse.migration.core.MigrationManager;
import com.genuitec.eclipse.migration.ui.wizard.MigrationWizard;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.ui.internal.ConvertProjectToFacetedFormRunnable;

public class InstallFacetCommand
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        block10: {
            IProjectFacet facetToInstall;
            IFacetedProject fp;
            IStructuredSelection selection;
            Shell shell;
            block12: {
                String facetId;
                IProject prj;
                block11: {
                    block9: {
                        Object firstElement;
                        IMigratingObject mProject;
                        shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
                        ISelection sel = HandlerUtil.getActiveMenuSelection((ExecutionEvent)event);
                        if (sel == null) {
                            sel = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
                        }
                        if ((mProject = MigrationManager.getMigratingObject((Object)(prj = (IProject)((IAdaptable)(firstElement = (selection = (IStructuredSelection)sel).getFirstElement())).getAdapter(IProject.class)))) != null && mProject.getState() != MigratingObjectState.MIGRATED && MessageDialog.openQuestion((Shell)shell, (String)"Migration Required", (String)"Adding facets to a non-migrated project can cause problems. Migrate?") && !MigrationWizard.syncOpenWizard((IMigrationCandidate[])new IMigrationCandidate[]{mProject.getMigrationCandidate()})) {
                            return null;
                        }
                        try {
                            if (prj.hasNature("org.eclipse.wst.common.project.facet.core.nature")) break block9;
                            if (MessageDialog.openQuestion((Shell)shell, (String)"Facet installation", (String)"Selected project will be converted to a faceted form. Do you want to continue?")) {
                                ConvertProjectToFacetedFormRunnable.runInProgressDialog((Shell)shell, (IProject)prj);
                                break block9;
                            }
                            return null;
                        }
                        catch (CoreException coreException) {}
                    }
                    fp = ProjectFacetsManager.create((IProject)prj);
                    if (fp == null) break block10;
                    facetId = event.getParameter("facet");
                    if (ProjectFacetsManager.isProjectFacetDefined((String)facetId)) break block11;
                    J2EEUICore.getDefault().log(MessageFormat.format("Facet {0} is not defined", facetId));
                    return null;
                }
                facetToInstall = ProjectFacetsManager.getProjectFacet((String)facetId);
                List<IProjectFacet> installableFacets = GenericFacetInstallationManagerImpl.getInstallableFacets(prj);
                if (installableFacets.contains(facetToInstall)) break block12;
                MessageDialog.openError((Shell)shell, (String)"Error", (String)MessageFormat.format("Project is no longer suitable for installation of {0} facet.", facetToInstall.getLabel()));
                return null;
            }
            try {
                GenericInstallFacetWizard wizard = new GenericInstallFacetWizard(fp, facetToInstall);
                WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
                wizard.init(UIUtil.getWorkbench(), selection);
                dialog.open();
                return null;
            }
            catch (Exception e) {
                new GenuitecCoreException((Plugin)J2EEUICore.getDefault(), (Throwable)e).log();
            }
        }
        return null;
    }
}

