/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.j2eedt.facet.ui;

import com.genuitec.eclipse.j2eedt.core.MavenUtil;
import com.genuitec.eclipse.j2eedt.core.Messages;
import com.genuitec.eclipse.j2eedt.core.version.IJEEVersionInfo;
import com.genuitec.eclipse.j2eedt.core.version.JEE;
import com.genuitec.eclipse.j2eedt.core.version.JEEProjectType;
import com.genuitec.eclipse.j2eedt.facet.IFacetConstants;
import com.genuitec.eclipse.j2eedt.facet.ui.FacetConfigurationCheckBox;
import com.genuitec.eclipse.j2eedt.facet.ui.FacetConfigurationCombo;
import com.genuitec.eclipse.j2eedt.facet.ui.FacetsConfigurationGroup;
import com.genuitec.eclipse.j2eedt.facet.ui.MEDataModelFacetCreationWizardPage;
import com.genuitec.eclipse.runtime.ui.RuntimeUIManager;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.componentcore.datamodel.properties.IFacetProjectCreationDataModelProperties;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

public abstract class MEJEEDataModelFacetCreationWizardPage
extends MEDataModelFacetCreationWizardPage
implements IFacetProjectCreationDataModelProperties {
    private boolean mavenSupportPossible = true;

    protected MEJEEDataModelFacetCreationWizardPage(IDataModel model, String pageName) {
        super(model, pageName);
    }

    @Override
    protected void addFacetSelectionControls(FacetsConfigurationGroup group) {
        this.addJEEVersionSelection(group);
    }

    private void addJEEVersionSelection(FacetsConfigurationGroup group) {
        ArrayList<String> jeeCaptions = new ArrayList<String>();
        ArrayList<IProjectFacetVersion> jeeVersions = new ArrayList<IProjectFacetVersion>();
        JEEProjectType modType = this.getJeeModuleType();
        IFacetProjectCreationDataModelProperties.FacetDataModelMap map = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)this.getDataModel().getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        IDataModel facetModel = map.getFacetDataModel(modType.getFacet().getId());
        JEE defaultJEEVersion = modType.getVersionInfo((IProjectFacetVersion)facetModel.getProperty("IFacetDataModelPropeties.FACET_VERSION")).getJEE();
        int defaultVersionIndex = -1;
        int i = JEE.values().length - 1;
        while (i > 0) {
            JEE jee = JEE.values()[i];
            IJEEVersionInfo versionInfo = modType.getVersionInfo(jee);
            if (versionInfo != null) {
                IProjectFacetVersion facetVersion = versionInfo.getFacetVersion();
                int j = 0;
                while (j < jeeVersions.size()) {
                    if (jeeVersions.get(j) == facetVersion) {
                        jeeCaptions.remove(j);
                        jeeVersions.remove(j);
                        break;
                    }
                    ++j;
                }
                if (defaultJEEVersion == jee) {
                    defaultVersionIndex = jeeVersions.size();
                }
                jeeCaptions.add(MessageFormat.format("{0} - {1}", jee.toString(), versionInfo.toString()));
                jeeVersions.add(facetVersion);
            }
            --i;
        }
        group.addFacetControl(new FacetConfigurationCombo("Java EE version:", ((IProjectFacetVersion)jeeVersions.get(0)).getProjectFacet().getId(), jeeCaptions.toArray(new String[jeeCaptions.size()]), jeeVersions.toArray(new IProjectFacetVersion[jeeVersions.size()]), defaultVersionIndex));
    }

    @Override
    protected void addMavenSupportSelection(FacetsConfigurationGroup group) {
        final boolean isMavenSupportAvailable = MavenUtil.isMavenSupportAvailable();
        if (this.mavenSupportPossible && IFacetConstants.MAVEN_10 != null && isMavenSupportAvailable) {
            group.addFacetControl(new FacetConfigurationCheckBox(null, "Add Maven support", IFacetConstants.MAVEN_10, false){

                @Override
                public void createControl(Composite parent) {
                    Composite wrapper = parent;
                    if (isMavenSupportAvailable) {
                        super.createSelectionControl(wrapper);
                    }
                    Link link = new Link(wrapper, 0);
                    link.setText("<a>" + Messages.NewJ2EEProjectDetailsWithSpecWizardPage_text_learn_maven + "</a>");
                    link.setLayoutData((Object)new GridData(131072, 4, true, false));
                    link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            PlatformUI.getWorkbench().getHelpSystem().displayHelpResource("https://www.genuitec.com/products/myeclipse/learning-center/maven/using-maven-in-myeclipse-maven4myeclipse/");
                        }
                    });
                }
            });
        }
    }

    protected abstract JEEProjectType getJeeModuleType();

    public boolean isMavenSupportPossible() {
        return this.mavenSupportPossible;
    }

    public void setMavenSupportPossible(boolean mavenSupportPossible) {
        this.mavenSupportPossible = mavenSupportPossible;
    }

    @Override
    public IRuntime chooseBestRuntime(List<IRuntime> runtimes) {
        for (IRuntime runtime : runtimes) {
            if (!runtime.getName().equals("com.genuitec.runtime.generic.java")) continue;
            return runtime;
        }
        for (IRuntime runtime : runtimes) {
            if (!runtime.getName().startsWith("com.genuitec.runtime.generic.")) continue;
            return runtime;
        }
        return null;
    }

    @Override
    protected boolean shouldAddNewRuntimeBtn() {
        return true;
    }

    @Override
    public boolean invokeAddNewRuntimeDialog() {
        IFacetedProjectWorkingCopy fpjwc = (IFacetedProjectWorkingCopy)this.model.getProperty("IFacetProjectCreationDataModelProperties.FACETED_PROJECT_WORKING_COPY");
        return RuntimeUIManager.openNewRuntimeDialog((Set)(fpjwc != null ? fpjwc.getProjectFacets() : null));
    }
}

