/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.j2eedt.facet.ui;

import com.genuitec.eclipse.j2eedt.facet.IFacetConstants;
import com.genuitec.eclipse.j2eedt.facet.MEFacetProjectCreationDataModelProvider;
import com.genuitec.eclipse.j2eedt.facet.MEJeeFacetProjectCreationDataModelProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.componentcore.datamodel.properties.IFacetProjectCreationDataModelProperties;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectEvent;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectListener;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

public class AbstractInstallFacetsDataModelProvider
extends MEFacetProjectCreationDataModelProvider {
    public static final String FACETS_TO_INSTALL_COLLECTION = "AbstractInstallFacetsDataModelProvider.FACETS_TO_INSTALL_COLLECTION";
    private final IFacetedProjectWorkingCopy fpjwc;

    public AbstractInstallFacetsDataModelProvider(IFacetedProject project) {
        this.fpjwc = project.createWorkingCopy();
    }

    public void init() {
        super.init();
        this.model.setProperty("IFacetProjectCreationDataModelProperties.FACETED_PROJECT_WORKING_COPY", (Object)this.fpjwc);
        this.model.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)this.fpjwc.getProject().getName());
        this.model.setProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME", (Object)this.fpjwc.getPrimaryRuntime());
        this.model.setBooleanProperty("FacetProjectCreationDataModelProvider.FORCE_VERSION_COMPLIANCE", false);
        this.fpjwc.addListener(new IFacetedProjectListener(){

            public void handleEvent(IFacetedProjectEvent event) {
                for (IFacetedProject.Action action : AbstractInstallFacetsDataModelProvider.this.fpjwc.getProjectFacetActions()) {
                    IDataModel dm;
                    Object config = action.getConfig();
                    if (config == null || !(config instanceof IDataModel) || !(dm = (IDataModel)config).getAllProperties().contains("FacetInstallDataModelProvider.MASTER_PROJECT_DM")) continue;
                    dm.setProperty("FacetInstallDataModelProvider.MASTER_PROJECT_DM", (Object)AbstractInstallFacetsDataModelProvider.this.model);
                }
            }
        }, new IFacetedProjectEvent.Type[]{IFacetedProjectEvent.Type.PROJECT_FACETS_CHANGED});
        this.fpjwc.addListener(new IFacetedProjectListener(){

            public void handleEvent(IFacetedProjectEvent event) {
                AbstractInstallFacetsDataModelProvider.this.model.notifyPropertyChange("IFacetProjectCreationDataModelProperties.FACET_RUNTIME", 4);
            }
        }, new IFacetedProjectEvent.Type[]{IFacetedProjectEvent.Type.TARGETABLE_RUNTIMES_CHANGED});
    }

    public IFacetedProjectWorkingCopy getFacetedProjectWorkingCopy() {
        return this.fpjwc;
    }

    public void dispose() {
        if (this.fpjwc != null) {
            this.fpjwc.dispose();
        }
        super.dispose();
    }

    public boolean propertySet(String propertyName, Object propertyValue) {
        if (FACETS_TO_INSTALL_COLLECTION.equals(propertyName)) {
            IFacetedProjectWorkingCopy fpjwc = (IFacetedProjectWorkingCopy)this.model.getProperty("IFacetProjectCreationDataModelProperties.FACETED_PROJECT_WORKING_COPY");
            IRuntime runtime = (IRuntime)this.getProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME");
            fpjwc.setTargetedRuntimes(Collections.EMPTY_SET);
            ArrayList toInstall = new ArrayList((Collection)propertyValue);
            IFacetProjectCreationDataModelProperties.FacetDataModelMap facetDmMap = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)this.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
            facetDmMap.clear();
            for (IFacetedProject.Action action : new ArrayList(fpjwc.getProjectFacetActions())) {
                if (action.getType() != IFacetedProject.Action.Type.INSTALL) continue;
                IProjectFacet facet = action.getProjectFacetVersion().getProjectFacet();
                if (toInstall.contains(facet)) {
                    toInstall.remove(facet);
                    Object config = action.getConfig();
                    if (!(config instanceof IDataModel)) {
                        config = Platform.getAdapterManager().loadAdapter(config, IDataModel.class.getName());
                    }
                    IDataModel dm = (IDataModel)config;
                    facetDmMap.put((Object)facet.getId(), (Object)dm);
                    continue;
                }
                fpjwc.removeProjectFacet(action.getProjectFacetVersion());
            }
            for (IProjectFacet facet : toInstall) {
                IProjectFacetVersion fv = facet.getDefaultVersion();
                if (!fpjwc.isFacetAvailable(fv)) {
                    fv = fpjwc.getHighestAvailableVersion(facet);
                }
                if (fv == null) continue;
                fpjwc.addProjectFacet(fv);
                IFacetedProject.Action action = fpjwc.getProjectFacetAction(facet);
                Object config = action.getConfig();
                if (!(config instanceof IDataModel)) {
                    config = Platform.getAdapterManager().loadAdapter(config, IDataModel.class.getName());
                }
                IDataModel dm = (IDataModel)config;
                facetDmMap.put((Object)facet.getId(), (Object)dm);
                for (String alias : facet.getAliases()) {
                    facetDmMap.put((Object)alias, (Object)dm);
                }
            }
            if (this.getProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME") == null || this.getProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME") == runtime) {
                boolean supports = true;
                if (runtime != null) {
                    for (IProjectFacetVersion fv : fpjwc.getProjectFacets()) {
                        if (runtime.supports(fv)) continue;
                        supports = false;
                        break;
                    }
                }
                if (!supports) {
                    this.setProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME", null);
                } else {
                    this.setProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME", runtime);
                }
            }
        }
        return super.propertySet(propertyName, propertyValue);
    }

    public Set getPropertyNames() {
        Set names = super.getPropertyNames();
        names.add("IFacetProjectCreationDataModelProperties.FACETED_PROJECT_WORKING_COPY");
        names.add("IFacetDataModelProperties.FACET_PROJECT_NAME");
        names.add("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        names.add("IFacetProjectCreationDataModelProperties.FACET_ACTION_MAP");
        names.add("IFacetProjectCreationDataModelProperties.FACET_RUNTIME");
        names.add("FacetProjectCreationDataModelProvider.FORCE_VERSION_COMPLIANCE");
        names.add(FACETS_TO_INSTALL_COLLECTION);
        return names;
    }

    public IStatus validate(String propertyName) {
        if (propertyName.equals("IFacetProjectCreationDataModelProperties.FACET_RUNTIME") && this.getProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME") == null) {
            IFacetedProjectWorkingCopy wc = (IFacetedProjectWorkingCopy)this.getProperty("IFacetProjectCreationDataModelProperties.FACETED_PROJECT_WORKING_COPY");
            if (IFacetConstants.MAVEN_10 != null && wc != null && wc.hasProjectFacet(IFacetConstants.MAVEN_FACET)) {
                return Status.OK_STATUS;
            }
            return MEJeeFacetProjectCreationDataModelProvider.NO_RUNTIME_SELECTED;
        }
        return super.validate(propertyName);
    }
}

